/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.jena.util.CollectionFactory;
import org.apache.jena.util.iterator.NiceIterator;

public class IteratorCollection {
    private IteratorCollection() {
    }

    public static <T> Set<T> iteratorToSet(Iterator<? extends T> i) {
        Set result = CollectionFactory.createHashedSet();
        try {
            while (i.hasNext()) {
                result.add(i.next());
            }
        }
        finally {
            NiceIterator.close(i);
        }
        return result;
    }

    public static <T> List<T> iteratorToList(Iterator<? extends T> it) {
        ArrayList<T> result = new ArrayList<T>();
        try {
            while (it.hasNext()) {
                result.add(it.next());
            }
        }
        finally {
            NiceIterator.close(it);
        }
        return result;
    }
}

