#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2019 BetaRays <array@dotslashplay.it>
# SPDX-FileCopyrightText: © 2020 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2021 HS-157
# SPDX-FileCopyrightText: © 2021 Hoël Bézier <hoelbezier@riseup.net>
set -o errexit

###
# Factorio
# send your bug reports to vv221@dotslashplay.it
###

script_version=20241121.1

PLAYIT_COMPATIBILITY_LEVEL='2.31'

GAME_ID='factorio'
GAME_NAME='Factorio'

GAME_NAME_SPACEAGE="${GAME_NAME}: Space Age"

GAME_ID_DEMO="${GAME_ID}-demo"
GAME_NAME_DEMO="$GAME_NAME (demo)"

# Archives

## Factorio (full game)

ARCHIVE_BASE_0_NAME='factorio_linux_2.0.7.tar.xz'
ARCHIVE_BASE_0_MD5='016efe181a57ebb649260b68b0696b3a'
ARCHIVE_BASE_0_SIZE='1973608'
ARCHIVE_BASE_0_VERSION='2.0.7-1'
ARCHIVE_BASE_0_URL='https://www.factorio.com/'

ARCHIVE_BASE_PRE2_15_NAME='factorio_alpha_x64_1.1.107.tar.xz'
ARCHIVE_BASE_PRE2_15_MD5='5c3294a7b2bd3b93a7cd9f8a7e785885'
ARCHIVE_BASE_PRE2_15_SIZE='1783701'
ARCHIVE_BASE_PRE2_15_VERSION='1.1.107-1'

ARCHIVE_BASE_PRE2_14_NAME='factorio_alpha_x64_1.1.91.tar.xz'
ARCHIVE_BASE_PRE2_14_MD5='3d906d237f44c5a3d7cd019f5733c53c'
ARCHIVE_BASE_PRE2_14_SIZE='1894576'
ARCHIVE_BASE_PRE2_14_VERSION='1.1.91-1'

ARCHIVE_BASE_PRE2_13_NAME='factorio_alpha_x64_1.1.87.tar.xz'
ARCHIVE_BASE_PRE2_13_MD5='d7972ea941172301e18ebb64694a10b6'
ARCHIVE_BASE_PRE2_13_SIZE='1750584'
ARCHIVE_BASE_PRE2_13_VERSION='1.1.87-1'

ARCHIVE_BASE_PRE2_12_NAME='factorio_alpha_x64_1.1.80.tar.xz'
ARCHIVE_BASE_PRE2_12_MD5='fc2e68ed66beedb82ad4a25023ac32aa'
ARCHIVE_BASE_PRE2_12_SIZE='1800000'
ARCHIVE_BASE_PRE2_12_VERSION='1.1.80-1'

ARCHIVE_BASE_PRE2_11_NAME='factorio_alpha_x64_1.1.77.tar.xz'
ARCHIVE_BASE_PRE2_11_MD5='ea6a481b694d73a956e45ea3ebe17a43'
ARCHIVE_BASE_PRE2_11_SIZE='1800000'
ARCHIVE_BASE_PRE2_11_VERSION='1.1.77-1'

ARCHIVE_BASE_PRE2_10_NAME='factorio_alpha_x64_1.1.76.tar.xz'
ARCHIVE_BASE_PRE2_10_MD5='c2a2302f2c1819a453a023789b3b8558'
ARCHIVE_BASE_PRE2_10_SIZE='1800000'
ARCHIVE_BASE_PRE2_10_VERSION='1.1.76-1'

ARCHIVE_BASE_PRE2_9_NAME='factorio_alpha_x64_1.1.61.tar.xz'
ARCHIVE_BASE_PRE2_9_MD5='d829704d00f92bef8d72ba3f36910529'
ARCHIVE_BASE_PRE2_9_SIZE='1800000'
ARCHIVE_BASE_PRE2_9_VERSION='1.1.61-1'

ARCHIVE_BASE_PRE2_8_NAME='factorio_alpha_x64_1.1.59.tar.xz'
ARCHIVE_BASE_PRE2_8_MD5='568328112d5b6e57c9e7a13237c85500'
ARCHIVE_BASE_PRE2_8_SIZE='1800000'
ARCHIVE_BASE_PRE2_8_VERSION='1.1.59-1'

ARCHIVE_BASE_PRE2_7_NAME='factorio_alpha_x64_1.1.57.tar.xz'
ARCHIVE_BASE_PRE2_7_MD5='c1e5392a9c7d2ead37de90c1ce4732ff'
ARCHIVE_BASE_PRE2_7_SIZE='1800000'
ARCHIVE_BASE_PRE2_7_VERSION='1.1.57-1'

ARCHIVE_BASE_PRE2_6_NAME='factorio_alpha_x64_1.1.53.tar.xz'
ARCHIVE_BASE_PRE2_6_MD5='3197e3b0de006f3c14027604ba39a244'
ARCHIVE_BASE_PRE2_6_SIZE='1800000'
ARCHIVE_BASE_PRE2_6_VERSION='1.1.53-1'

ARCHIVE_BASE_PRE2_5_NAME='factorio_alpha_x64_1.1.41.tar.xz'
ARCHIVE_BASE_PRE2_5_MD5='9dbe3f0b17a2f217f62b1d6b756897dc'
ARCHIVE_BASE_PRE2_5_SIZE='1800000'
ARCHIVE_BASE_PRE2_5_VERSION='1.1.41-1'

ARCHIVE_BASE_PRE2_4_NAME='factorio_alpha_x64_1.1.39.tar.xz'
ARCHIVE_BASE_PRE2_4_MD5='92dae2519513f87cc9b25c26930a21a9'
ARCHIVE_BASE_PRE2_4_SIZE='1800000'
ARCHIVE_BASE_PRE2_4_VERSION='1.1.39-1'

ARCHIVE_BASE_PRE2_3_NAME='factorio_alpha_x64_1.1.30.tar.xz'
ARCHIVE_BASE_PRE2_3_MD5='b039e25fef976f2ebe77bf5d9bca3c90'
ARCHIVE_BASE_PRE2_3_SIZE='1800000'
ARCHIVE_BASE_PRE2_3_VERSION='1.1.30-1'

ARCHIVE_BASE_PRE2_2_NAME='factorio_alpha_x64_1.1.27.tar.xz'
ARCHIVE_BASE_PRE2_2_MD5='71c370e0363c40e95f0a9af56b8f4a9b'
ARCHIVE_BASE_PRE2_2_SIZE='1800000'
ARCHIVE_BASE_PRE2_2_VERSION='1.1.27-1'

ARCHIVE_BASE_PRE2_1_NAME='factorio_alpha_x64_1.1.19.tar.xz'
ARCHIVE_BASE_PRE2_1_MD5='ffe7310259e6176d20fc4add10d8a3d3'
ARCHIVE_BASE_PRE2_1_SIZE='1800000'
ARCHIVE_BASE_PRE2_1_VERSION='1.1.19-1'

ARCHIVE_BASE_PRE2_0_NAME='factorio_alpha_x64_1.0.0.tar.xz'
ARCHIVE_BASE_PRE2_0_MD5='001910cafbfa8f4ac61b2897f91fe77e'
ARCHIVE_BASE_PRE2_0_SIZE='1700000'
ARCHIVE_BASE_PRE2_0_VERSION='1.0.0-1'

## Factorio including Space Age expansion

ARCHIVE_BASE_SPACEAGE_0_NAME='factorio-space-age_linux_2.0.7.tar.xz'
ARCHIVE_BASE_SPACEAGE_0_MD5='56559ce107be62443b8743dc8696f65e'
ARCHIVE_BASE_SPACEAGE_0_SIZE='4741087'
ARCHIVE_BASE_SPACEAGE_0_VERSION='2.0.7-1'
ARCHIVE_BASE_SPACEAGE_0_URL='https://www.factorio.com/'

## Factorio (demo)

ARCHIVE_BASE_DEMO_13_NAME='factorio_demo_x64_1.1.107.tar.xz'
ARCHIVE_BASE_DEMO_13_MD5='e59b6e296f2080d1f80df3090f3b40d4'
ARCHIVE_BASE_DEMO_13_SIZE='1645945'
ARCHIVE_BASE_DEMO_13_VERSION='1.1.107-1'
ARCHIVE_BASE_DEMO_13_URL='https://www.factorio.com/download'

ARCHIVE_BASE_DEMO_12_NAME='factorio_demo_x64_1.1.91.tar.xz'
ARCHIVE_BASE_DEMO_12_MD5='b4c599f44952033e5830f3fee78cb41f'
ARCHIVE_BASE_DEMO_12_SIZE='1687672'
ARCHIVE_BASE_DEMO_12_VERSION='1.1.91-1'

ARCHIVE_BASE_DEMO_11_NAME='factorio_demo_x64_1.1.87.tar.xz'
ARCHIVE_BASE_DEMO_11_MD5='7968cbd443ad7d562c6bbbb5a5f99d0d'
ARCHIVE_BASE_DEMO_11_SIZE='1687456'
ARCHIVE_BASE_DEMO_11_VERSION='1.1.87-1'

ARCHIVE_BASE_DEMO_10_NAME='factorio_demo_x64_1.1.76.tar.xz'
ARCHIVE_BASE_DEMO_10_MD5='bf5eb5cf72137a87ea1055cf9b39967a'
ARCHIVE_BASE_DEMO_10_SIZE='1700000'
ARCHIVE_BASE_DEMO_10_VERSION='1.1.76-1'

ARCHIVE_BASE_DEMO_9_NAME='factorio_demo_x64_1.1.59.tar.xz'
ARCHIVE_BASE_DEMO_9_MD5='c40c223284a8a373800bf777d364f5b2'
ARCHIVE_BASE_DEMO_9_SIZE='1700000'
ARCHIVE_BASE_DEMO_9_VERSION='1.1.59-1'

ARCHIVE_BASE_DEMO_8_NAME='factorio_demo_x64_1.1.53.tar.xz'
ARCHIVE_BASE_DEMO_8_MD5='79bafca740b1ea6fb13ab94b79845601'
ARCHIVE_BASE_DEMO_8_SIZE='1700000'
ARCHIVE_BASE_DEMO_8_VERSION='1.1.53-1'

ARCHIVE_BASE_DEMO_7_NAME='factorio_demo_x64_1.1.41.tar.xz'
ARCHIVE_BASE_DEMO_7_MD5='df020fa5c98690d8aedf8cb23b80bce3'
ARCHIVE_BASE_DEMO_7_VERSION='1.1.41-1'
ARCHIVE_BASE_DEMO_7_SIZE='1700000'

ARCHIVE_BASE_DEMO_6_NAME='factorio_demo_x64_1.1.39.tar.xz'
ARCHIVE_BASE_DEMO_6_MD5='cabef150f9b7af9b1480d2590b7799ec'
ARCHIVE_BASE_DEMO_6_VERSION='1.1.39-1'
ARCHIVE_BASE_DEMO_6_SIZE='1700000'

ARCHIVE_BASE_DEMO_5_NAME='factorio_demo_x64_1.1.33.tar.xz'
ARCHIVE_BASE_DEMO_5_MD5='82cc1137048cf98121cd6943e51ae597'
ARCHIVE_BASE_DEMO_5_VERSION='1.1.33-1'
ARCHIVE_BASE_DEMO_5_SIZE='1700000'

ARCHIVE_BASE_DEMO_4_NAME='factorio_demo_x64_1.1.32.tar.xz'
ARCHIVE_BASE_DEMO_4_MD5='275b63133ac56e59ccb73e98f5bebed2'
ARCHIVE_BASE_DEMO_4_VERSION='1.1.32-1'
ARCHIVE_BASE_DEMO_4_SIZE='1700000'

ARCHIVE_BASE_DEMO_3_NAME='factorio_demo_x64_1.1.30.tar.xz'
ARCHIVE_BASE_DEMO_3_MD5='36186abcbe560591bd8e4c207291409f'
ARCHIVE_BASE_DEMO_3_VERSION='1.1.30-1'
ARCHIVE_BASE_DEMO_3_SIZE='1700000'

ARCHIVE_BASE_DEMO_2_NAME='factorio_demo_x64_1.1.27.tar.xz'
ARCHIVE_BASE_DEMO_2_MD5='cdb61b4b98a704e9c6a1090938dfabee'
ARCHIVE_BASE_DEMO_2_VERSION='1.1.27-1'
ARCHIVE_BASE_DEMO_2_SIZE='1700000'

ARCHIVE_BASE_DEMO_1_NAME='factorio_demo_x64_1.0.0.tar.xz'
ARCHIVE_BASE_DEMO_1_MD5='3995194f9c4b4368ecf27ffa9234008e'
ARCHIVE_BASE_DEMO_1_VERSION='1.0.0-1'
ARCHIVE_BASE_DEMO_1_SIZE='1400000'

ARCHIVE_BASE_DEMO_0_NAME='factorio_demo_x64_0.16.51.tar.xz'
ARCHIVE_BASE_DEMO_0_MD5='130267c91df0be6c2034b64fb05d389b'
ARCHIVE_BASE_DEMO_0_VERSION='0.16.51-1'
ARCHIVE_BASE_DEMO_0_SIZE='680000'


CONTENT_PATH_DEFAULT='factorio'
CONTENT_GAME_BIN_FILES='
bin/x64/factorio'
CONTENT_GAME_DATA_SPACEAGE_FILES='
data/elevated-rails
data/quality
data/space-age'
CONTENT_GAME_DATA_FILES='
data
config-path.cfg'
CONTENT_DOC_DATA_FILES='
doc-html'

USER_PERSISTENT_FILES='
*.cfg
*.dat
player-data.json'
USER_PERSISTENT_DIRECTORIES='
config
mods
saves'

APP_MAIN_EXE='bin/x64/factorio'
APP_MAIN_ICON='data/core/graphics/factorio-icon.png'
## Work around the engine poor support for symbolic links
APP_MAIN_PRERUN='
# Work around the engine poor support for symbolic links
for mod in core base elevated-rails quality space-age; do
	if [ ! -h "data/${mod}" ] && [ -e "${PATH_GAME_DATA}/data/${mod}" ]; then
		rm --force --recursive "data/${mod}"
		ln --symbolic "${PATH_GAME_DATA}/data/${mod}" "data/${mod}"
	fi
done
'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'
PACKAGES_LIST_SPACEAGE='
PKG_BIN
PKG_DATA_SPACEAGE
PKG_DATA'

PKG_BIN_ID_SPACEAGE="${GAME_ID}-space-age"
PKG_BIN_ID_DEMO="$GAME_ID_DEMO"
PKG_BIN_PROVIDES_SPACEAGE="
$GAME_ID"
PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_SIBLINGS_SPACEAGE='
PKG_DATA
PKG_DATA_SPACEAGE'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libm.so.6
libpthread.so.0
libresolv.so.2
librt.so.1'
PKG_BIN_DEPENDENCIES_LIBRARIES_PRE2='
libasound.so.2
libc.so.6
libdl.so.2
libGL.so.1
libm.so.6
libpthread.so.0
libpulse-simple.so.0
libpulse.so.0
libresolv.so.2
librt.so.1
libX11.so.6
libXcursor.so.1
libXext.so.6
libXinerama.so.1
libXrandr.so.2'
PKG_BIN_DEPENDENCIES_LIBRARIES_DEMO="$PKG_BIN_DEPENDENCIES_LIBRARIES_PRE2"

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_ID_DEMO="${GAME_ID_DEMO}-data"
PKG_DATA_DESCRIPTION='data'

PKG_DATA_SPACEAGE_ID="${PKG_DATA_ID}-space-age"
PKG_DATA_SPACEAGE_DESCRIPTION="$PKG_DATA_DESCRIPTION - Space Age"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
