#############################################################################
##
#W    matgrp4.gi                                                Karel Dekimpe
#W                                                               Bettina Eick
##
##    This file contains the 4-dimensional almost crystallographic groups
##    as integral matrix groups. There are 95 types of groups.
##
ACDim4Nr001 := function ( k1, k2, k3)
local a, b, c, d;
a :=[[1, 0, -k1/2, -k2/2, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], 
   [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
b :=[[1, k1/2, 0, -k3/2, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], 
   [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
c :=[[1, k2/2, k3/2, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], 
   [0, 0, 0, 1, 1], [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
return Group( [a, b, c, d] , IdentityMat(5) );
end;
 
ACDim4Nr002 := function ( k1, k2, k3, k4, k5, k6, k7)
local a, b, c, d, alfa;
a :=[[1, 0, -k1/2, -k2/2, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], 
   [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
b :=[[1, k1/2, 0, -k3/2, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], 
   [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
c :=[[1, k2/2, k3/2, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], 
   [0, 0, 0, 1, 1], [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k4, k5, k6, k7/2], [0, -1, 0, 0, 0], [0, 0, -1, 0, 0], 
   [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa] , IdentityMat(5) );
end;
 
ACDim4Nr003 := function ( k1, k2, k3, k4)
local a, b, c, d, alfa;
a :=[[1, 0, 0, -k1/2, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, k1/2, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k2, 0, k3, k4/2], [0, -1, 0, 0, 0], [0, 0, 1, 0, 0], 
   [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa] , IdentityMat(5) );
end;
 
ACDim4Nr004 := function ( k1, k2, k3, k4)
local a, b, c, d, alfa;
a :=[[1, 0, 0, - k1/2, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], 
   [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
b :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, k1/2, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k2, 0, k3, k4/2], [0, -1, 0, 0, 0], [0, 0, 1, 0, 1/2], 
   [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa] , IdentityMat(5) );
end;
 
ACDim4Nr004b := function ( k1, k2, k3)
local a, b, c, d, alfa;
a :=[[1, 0, -k1, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, k1, 0, -k2, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, k2, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[-1, -k1/2, 2*k3, k2/2,  0], [0, -1, 0, 0, 0], [0, 0, 1, 0, 1/2], 
   [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa] , IdentityMat(5) );
end;
 
ACDim4Nr005 := function ( k1, k2, k3, k4)
local a, b, c, d, alfa;
a :=[[1, 0, 0, -k1/2, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, 0, 0, -k1/2, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, k1/2, k1/2, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], 
   [0, 0, 0, 1, 1], [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k2, k2, k3, k4/2], [0, 0, -1, 0, 0], [0, -1, 0, 0, 0], 
   [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa] , IdentityMat(5) );
end;
 
ACDim4Nr006 := function ( k1, k2, k3)
local a, b, c, d, alfa;
a :=[[1, 0, 0, -k1/2, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, k1/2, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, 0, k2, 0, k3/2], [0, 1, 0, 0, 0], [0, 0, -1, 0, 0], 
   [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa] , IdentityMat(5) );
end;
 
ACDim4Nr007 := function ( k1, k2, k3)
local a, b, c, d, alfa;
a :=[[1, 0, 0, -k1, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, k1, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k1/2, k2, 0, k3/2], [0, 1, 0, 0, 0], [0, 0, -1, 0, 0], 
   [0, 0, 0, 1, 1/2], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa] , IdentityMat(5) );
end;
 
ACDim4Nr007b := function ( k1, k2, k3, k4)
local a, b, c, d, alfa;
a :=[[1, 0, -k1/2, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, k1/2, 0, -k2, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, k2, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[-1, -k3, -k2/2, 2*k4,  0], [0, 1, 0, 0, 0], [0, 0, -1, 0, 0], 
   [0, 0, 0, 1, 1/2], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa] , IdentityMat(5) );
end;
 
ACDim4Nr008 := function ( k1, k2, k3)
local a, b, c, d, alfa;
a :=[[1, 0, 0, -k1/2, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, 0, 0, -k1/2, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, k1/2, k1/2, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], 
   [0, 0, 0, 1, 1], [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k2, -k2, 0, k3/2], [0, 0, 1, 0, 0], [0, 1, 0, 0, 0], 
   [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa] , IdentityMat(5) );
end;
 
ACDim4Nr009 := function ( k1, k2, k3)
local a, b, c, d, alfa;
a :=[[1, 0, 0, -k1/2, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, 0, 0, -k1/2, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, k1/2, k1/2, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], 
   [0, 0, 0, 1, 1], [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, -k1/4 + k2, (3*k1)/4 - k2, 0, k3/2], [0, 0, 1, 0, 0], 
   [0, 1, 0, 0, 0], [0, 0, 0, 1, 1/2], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa] , IdentityMat(5) );
end;
 
ACDim4Nr009b := function ( k1, k2, k3, k4)
local a, b, c, d, alfa;
a :=[[1, 0, -k1/2, -k2/2, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], 
   [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
b :=[[1, k1/2, 0, k2/2, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], 
   [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
c :=[[1, k2/2, -k2/2, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], 
   [0, 0, 0, 1, 1], [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[-1, k2/4 - k3, (3*k2)/4 - k3, 2*k4,  0], [0, 0, 1, 0, 0], 
   [0, 1, 0, 0, 0], [0, 0, 0, 1, 1/2], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa] , IdentityMat(5) );
end;
 
ACDim4Nr010 := function ( k1, k2, k3, k4, k5, k6)
local a, b, c, d, alfa, beta;
a :=[[1, 0, 0, -k1/2, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, k1/2, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k2, 0, k3, k4/2], [0, -1, 0, 0, 0], [0, 0, 1, 0, 0], 
   [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
beta :=[[1, k2, k5, k3, k6/2], [0, -1, 0, 0, 0], [0, 0, -1, 0, 0], 
   [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr011 := function ( k1, k2, k3, k4, k5, k6)
local a, b, c, d, alfa, beta;
a :=[[1, 0, 0, -k1/2, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, k1/2, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k2, 0, k3, k4/2], [0, -1, 0, 0, 0], [0, 0, 1, 0, 1/2], 
   [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
beta :=[[1, k2, -2*k6, k3, k5/2], [0, -1, 0, 0, 0], [0, 0, -1, 0, 0], 
   [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr012 := function ( k1, k2, k3, k4, k5, k6)
local a, b, c, d, alfa, beta;
a :=[[1, 0, 0, -k1/2, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, 0, 0, -k1/2, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, k1/2, k1/2, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], 
   [0, 0, 0, 1, 1], [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k2, k2, k3, k4/2], [0, 0, -1, 0, 0], [0, -1, 0, 0, 0], 
   [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
beta :=[[1, k5, 2*k2 - k5, k3, k6/2], [0, -1, 0, 0, 0], [0, 0, -1, 0, 0], 
   [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr013 := function ( k1, k2, k3, k4, k5, k6)
local a, b, c, d, alfa, beta;
a :=[[1, 0, 0, -k1, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, k1, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k1/2 + k2, 0, -2*k6, k3/2 + k6/2], [0, -1, 0, 0, 0], 
   [0, 0, 1, 0, 0], [0, 0, 0, -1, 1/2], [0, 0, 0, 0, 1]];
beta :=[[1, k1 + k2, k4, -2*k6, k5/2], [0, -1, 0, 0, 0], [0, 0, -1, 0, 0], 
   [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr014 := function ( k1, k2, k3, k4, k5, k6)
local a, b, c, d, alfa, beta;
a:=[[1, 0, 0, -k1, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
 [0, 0, 0, 0, 1]];
b:=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
 [0, 0, 0, 0, 1]];
c:=[[1, k1, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
 [0, 0, 0, 0, 1]];
d:=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa:=[[1, k1/2+ k2, 0, k3, -k3/4 + k4/2], [0, -1, 0, 0, 0], [0, 0, 1, 0, 1/2], 
 [0, 0, 0, -1, 1/2], [0, 0, 0, 0, 1]];
beta:=[[1, k1 + k2, -k3 - 2*k6, k3, k5/2], [0, -1, 0, 0, 0], [0, 0, -1, 0, 0], 
 [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr014b := function ( k1, k2, k3, k4, k5, k6)
local a, b, c, d, alfa, beta;
a :=[[1, 0, -k1, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, k1, 0, -k2, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, k2, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[-1, -k1/2, -k2/2 + 2*k3, k2/2,  0], [0, -1, 0, 0, 0], 
   [0, 0, 1, 0, 1/2], [0, 0, 0, -1, 1/2], [0, 0, 0, 0, 1]];
beta :=[[1, k4, k2 - 2*k3, k2 + 2*k3 - 2*k5 + 2*k6, k5/2], [0, -1, 0, 0, 0], 
   [0, 0, -1, 0, 0], [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr015 := function ( k1, k2, k3, k4, k5, k6)
local a, b, c, d, alfa, beta;
a :=[[1, 0, 0, -k1/2, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, 0, 0, -k1/2, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, k1/2, k1/2, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], 
   [0, 0, 0, 1, 1], [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k1/4 + k2, k1/4 + k2, -2*k6, k3/2 + k6/2], [0, 0, -1, 0, 0], 
   [0, -1, 0, 0, 0], [0, 0, 0, -1, 1/2], [0, 0, 0, 0, 1]];
beta :=[[1, k4, k1 + 2*k2 - k4, -2*k6, k5/2], [0, -1, 0, 0, 0], 
   [0, 0, -1, 0, 0], [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr018 := function ( k1, k2, k3, k4)
local a, b, c, d, alfa, beta;
a :=[[1, 0, -k1, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, k1, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, -k1 + 2*k2 - 2*k3 + 2*k4, k1/2 - 2*k3, 0, 
    k2/2 - (-k1 + 2*k2 - 2*k3 + 2*k4)/4], [0, -1, 0, 0, 1/2], 
   [0, 0, -1, 0, 0], [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
beta :=[[-1, -k1/2, 2*k3, 0,  0], [0, -1, 0, 0, 0], [0, 0, 1, 0, 1/2], 
   [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr019 := function ( k1, k2, k3, k4)
local a, b, c, d, alfa, beta;
a :=[[1, 0, 0, -k1, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, k1, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[-1, -k1/2, 0, k1/2 + 2*k2,  0], [0, -1, 0, 0, 1/2], 
   [0, 0, -1, 0, 0], [0, 0, 0, 1, 1/2], [0, 0, 0, 0, 1]];
beta :=[[1, 3*k1 + 2*k2 - 2*k3 + 2*k4, 0, -k1 - 2*k2, k3/2], 
   [0, -1, 0, 0, 0], [0, 0, 1, 0, 1/2], [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr019b := function ( k1, k2, k3, k4)
local a, b, c, d, alfa, beta;
a :=[[1, 0, -k1, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, k1, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, -k1 + 2*k2 - 2*k3 + 2*k4, k1/2 - 2*k3, 0, 
    k2/2 - (-k1 + 2*k2 - 2*k3 + 2*k4)/4], [0, -1, 0, 0, 1/2], 
   [0, 0, -1, 0, 0], [0, 0, 0, 1, 1/2], [0, 0, 0, 0, 1]];
beta :=[[-1, -k1/2, 2*k3, 0,  0], [0, -1, 0, 0, 0], [0, 0, 1, 0, 1/2], 
   [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr019c := function ( k1, k2, k3, k4)
local a, b, c, d, alfa, beta;
a :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, 0, 0, -k1, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, k1, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[-1, 0, -k1/2, 2*k2, -(- (3*k1)/2 - k4)/2], [0, -1, 0, 0, 1/2], 
   [0, 0, -1, 0, 0], [0, 0, 0, 1, 1/2], [0, 0, 0, 0, 1]];
beta :=[[-1, 0, 2*k3, k1/2,  0], [0, -1, 0, 0, 0], [0, 0, 1, 0, 1/2], 
   [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr026 := function ( k1, k2, k3, k4)
local a, b, c, d, alfa, beta;
a :=[[1, 0, 0, -k1, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, k1, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[-1, -k1/2, 0, 2*k2,  0], [0, -1, 0, 0, 0], [0, 0, -1, 0, 0], 
   [0, 0, 0, 1, 1/2], [0, 0, 0, 0, 1]];
beta :=[[1, 0, k3, 0, k4/2], [0, 1, 0, 0, 0], [0, 0, -1, 0, 0], 
   [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr027 := function ( k1, k2, k3, k4, k5)
local a, b, c, d, alfa, beta;
a :=[[1, 0, -k1/2, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, k1/2, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k2, k3, 0, k4/2], [0, -1, 0, 0, 0], [0, 0, -1, 0, 0], 
   [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
beta :=[[-1, -k2, 0, 2*k5,  0], [0, 1, 0, 0, 0], [0, 0, -1, 0, 0], 
   [0, 0, 0, 1, 1/2], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr029 := function ( k1, k2, k3, k4)
local a, b, c, d, alfa, beta;
a :=[[1, 0, 0, -k1, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, k1, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[-1, -k1/2, 0, 2*k2,  0], [0, -1, 0, 0, 0], [0, 0, -1, 0, 1/2], 
   [0, 0, 0, 1, 1/2], [0, 0, 0, 0, 1]];
beta :=[[1, k1/2, 2*k2 - 2*k3 + 2*k4, 0, k3/2], [0, 1, 0, 0, 0], 
   [0, 0, -1, 0, 0], [0, 0, 0, 1, 1/2], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr029b := function ( k1, k2, k3, k4, k5)
local a, b, c, d, alfa, beta;
a :=[[1, 0, -k1, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, k1, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k1/2 + k2, 2*k3 - 2*k4 + 2*k5, 0, k3/2 - (2*k3 - 2*k4 + 2*k5)/4], 
   [0, -1, 0, 0, 0], [0, 0, -1, 0, 1/2], [0, 0, 0, 1, 1/2], [0, 0, 0, 0, 1]];
beta :=[[-1, -k1 - k2, 0, 2*k4,  0], [0, 1, 0, 0, 0], [0, 0, -1, 0, 0], 
   [0, 0, 0, 1, 1/2], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr029c := function ( k1, k2, k3, k4)
local a, b, c, d, alfa, beta;
a :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, 0, 0, -2*k1, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, 2*k1, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[-1, 0, -k1, -k1 + 2*(k1 + k2), -k1], [0, -1, 0, 0, 0], 
   [0, 0, -1, 0, 1/2], [0, 0, 0, 1, 1/2], [0, 0, 0, 0, 1]];
beta :=[[-1, -k3, -k1, 2*(k1 + k2), -k4/2], [0, 1, 0, 0, 0], 
   [0, 0, -1, 0, 0], [0, 0, 0, 1, 1/2], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr030 := function ( k1, k2, k3, k4, k5)
local a, b, c, d, alfa, beta;
a :=[[1, 0, -k1, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, k1, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k1/2 + k2, 2*k3 + 2*k5, 0, k3/2 - (2*k3 + 2*k5)/4], 
   [0, -1, 0, 0, 0], [0, 0, -1, 0, 1/2], [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
beta :=[[-1, -k1 - k2, 0, 2*k4,  0], [0, 1, 0, 0, 0], [0, 0, -1, 0, 0], 
   [0, 0, 0, 1, 1/2], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr031 := function ( k1, k2, k3, k4)
local a, b, c, d, alfa, beta;
a :=[[1, 0, 0, -k1, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, k1, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[-1, -k1/2, 0, 2*k2,  0], [0, -1, 0, 0, 0], [0, 0, -1, 0, 1/2], 
   [0, 0, 0, 1, 1/2], [0, 0, 0, 0, 1]];
beta :=[[1, 0, -2*k3 + 2*k4, 0, k3/2], [0, 1, 0, 0, 0], [0, 0, -1, 0, 0], 
   [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr032 := function ( k1, k2, k3, k4, k5)
local a, b, c, d, alfa, beta;
a :=[[1, 0, -k1, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, k1, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, -k1/2 - 2*k4, -3*k1 + 2*k2 - 2*k4 + 2*k5, 0, 
    k2/2 - (-3*k1 + 2*k2 - 2*k4 + 2*k5)/4], [0, -1, 0, 0, 0], 
   [0, 0, -1, 0, 1/2], [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
beta :=[[-1, 2*k4, k1/2, -k3,  0], [0, 1, 0, 0, 1/2], [0, 0, -1, 0, 0], 
   [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr033 := function ( k1, k2, k3, k4)
local a, b, c, d, alfa, beta;
a :=[[1, 0, 0, -k1, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, k1, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[-1, -k1/2, 0, 2*k2,  0], [0, -1, 0, 0, 0], [0, 0, -1, 0, 1/2], 
   [0, 0, 0, 1, 1/2], [0, 0, 0, 0, 1]];
beta :=[[1, 0, -k1 - 2*k3 + 2*k4, -k1/2, k3/2], [0, 1, 0, 0, 1/2], 
   [0, 0, -1, 0, 0], [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr033b := function ( k1, k2, k3, k4, k5)
local a, b, c, d, alfa, beta;
a :=[[1, 0, -k1, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, k1, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, -k1/2 - 2*k4, -3*k1 + 2*k2 + k3 - 2*k4 + 2*k5, 0, 
    k2/2 - (-3*k1 + 2*k2 + k3 - 2*k4 + 2*k5)/4], [0, -1, 0, 0, 0], 
   [0, 0, -1, 0, 1/2], [0, 0, 0, 1, 1/2], [0, 0, 0, 0, 1]];
beta :=[[-1, 2*k4, k1/2, -k3,  0], [0, 1, 0, 0, 1/2], [0, 0, -1, 0, 0], 
   [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr033c := function ( k1, k2, k3, k4)
local a, b, c, d, alfa, beta;
a :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, 0, 0, -k1, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, k1, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[-1, 0, -k1/2, k1/2 + 2*k2, k2/2], [0, -1, 0, 0, 0], 
   [0, 0, -1, 0, 1/2], [0, 0, 0, 1, 1/2], [0, 0, 0, 0, 1]];
beta :=[[-1, 2*k3, 0, k1 + 2*k2, -k4/2], [0, 1, 0, 0, 1/2], [0, 0, -1, 0, 0], 
   [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr034 := function ( k1, k2, k3, k4, k5)
local a, b, c, d, alfa, beta;
a :=[[1, 0, -k1, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, k1, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k1/2 + k2, -2*k1 + k2 + 2*k3 + 2*k5, 0, 
    k3/2 - (-2*k1 + k2 + 2*k3 + 2*k5)/4], [0, -1, 0, 0, 0], 
   [0, 0, -1, 0, 1/2], [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
beta :=[[-1, -k1 - k2, k1/2, k1 + k2 + 2*k4,  0], [0, 1, 0, 0, 1/2], 
   [0, 0, -1, 0, 0], [0, 0, 0, 1, 1/2], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr036 := function ( k1, k2, k3, k4)
local a, b, c, d, alfa, beta;
a :=[[1, 0, 0, -k1, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, 0, 0, -k1, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, k1, k1, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[-1, -k1/2, -k1/2, 2*k2,  0], [0, -1, 0, 0, 0], [0, 0, -1, 0, 0], 
   [0, 0, 0, 1, 1/2], [0, 0, 0, 0, 1]];
beta :=[[1, k3, -k3, 0, k4/2], [0, 0, 1, 0, 0], [0, 1, 0, 0, 0], 
   [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr037 := function ( k1, k2, k3, k4, k5)
local a, b, c, d, alfa, beta;
a :=[[1, 0, -k1/2, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, k1/2, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k2, -k2 + 2*k4, 0, k3/2], [0, -1, 0, 0, 0], [0, 0, -1, 0, 0], 
   [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
beta :=[[-1, -k4, -k4, 2*k5,  0], [0, 0, 1, 0, 0], [0, 1, 0, 0, 0], 
   [0, 0, 0, 1, 1/2], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr041 := function ( k1, k2, k3, k4, k5)
local a, b, c, d, alfa, beta;
a :=[[1, 0, 0, -k1, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, 0, 0, -k1, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, k1, k1, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k2, k2, k1 - 2*k5, -k2/2 + k3/2], [0, 0, -1, 0, 1/2], 
   [0, -1, 0, 0, 1/2], [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
beta :=[[-1, k1/2 - k4, (-3*k1)/2 + k4, 2*k5,  0], [0, 0, -1, 0, 0], 
   [0, -1, 0, 0, 0], [0, 0, 0, 1, 1/2], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr043 := function ( k1, k2, k3, k4, k5)
local a, b, c, d, alfa, beta;
a :=[[1, 0, -k1/2, -k1/2, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], 
   [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
b :=[[1, k1/2, 0, k1/2, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], 
   [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
c :=[[1, k1/2, -k1/2, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], 
   [0, 0, 0, 1, 1], [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, -k1/4 + k2 + 2*k3 + 2*k5, k1/4 + k2, 2*k2 + 2*k3 + 2*k5, 
    k3/2 - (2*k2 + 2*k3 + 2*k5)/4], [0, 0, 1, 0, 0], [0, 1, 0, 0, 0], 
   [0, -1, -1, -1, 1/2], [0, 0, 0, 0, 1]];
beta :=[[-1, -k1/4 + k2 + 2*k4, 2*k4, -k1/4 - k2,  0], [0, 0, 0, -1, 0], 
   [0, 1, 1, 1, 1/2], [0, -1, 0, 0, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr045 := function ( k1, k2, k3, k4, k5)
local a, b, c, d, alfa, beta;
a:=[[1, 0, 0, -k1/2, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
 [0, 0, 0, 0, 1]];
b:=[[1, 0, 0, k1/2, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
 [0, 0, 0, 0, 1]];
c:=[[1, k1/2, -k1/2, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
 [0, 0, 0, 0, 1]];
d:=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa:=[[1,k2, -k2, k2 - 2*k4 - 2*k5, k3/2], [0, 0, 1, -1, 0], [0, 1, 0, -1, 0], 
 [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
beta:=[[-1, -k4, k4 + 2*k5, k4, 0], [0, 0, 1, -1, 1/2], [0, 0, 1, 0, 1/2], 
 [0, -1, 1, 0, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr055 := function ( k1, k2, k3, k4, k5, k6)
local a, b, c, d, alfa, beta, gamma;
a :=[[1, 0, -k1, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, k1, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, -k1 - 2*k2 + 2*k3 - 2*k4, -k1 - 2*k3, 0, k2/2], [0, -1, 0, 0, 0], 
   [0, 0, -1, 0, 0], [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
beta :=[[-1, -k1/2, k1/2 + 2*k3, 0,  0], [0, -1, 0, 0, 1/2], 
   [0, 0, 1, 0, 1/2], [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
gamma :=[[1, -k1 - 2*k2 + 2*k3 - 2*k4, -k1 - 2*k3, k5, 
    (2*k1 + k2 + k4 + k6)/2], [0, -1, 0, 0, 0], [0, 0, -1, 0, 0], 
   [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta, gamma] , IdentityMat(5) );
end;
 
ACDim4Nr056 := function ( k1, k2, k3, k4, k5, k6)
local a, b, c, d, alfa, beta, gamma;
a :=[[1, 0, -k1, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, k1, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, -k1/2 + 2*k2 - 2*k3 + 2*(k1 - k2 + 2*k3 - k4), k1/2 - 2*k3, 0, 
    k2/2 - (k1 - 2*k3)/4 - (-k1 + 2*k2 - 2*k3 + 2*(k1 - k2 + 2*k3 - k4))/4], 
   [0, -1, 0, 0, 1/2], [0, 0, -1, 0, 1/2], [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
beta :=[[-1, -k1/2, 2*k3, 0,  0], [0, -1, 0, 0, 0], [0, 0, 1, 0, 1/2], 
   [0, 0, 0, -1, 1/2], [0, 0, 0, 0, 1]];
gamma :=[[1, 2*k2 - 2*k3 + 2*(k1 - k2 + 2*k3 - k4), -2*k3, 
    2*k3 + 2*k5 - 2*k6, k6/2], [0, -1, 0, 0, 0], [0, 0, -1, 0, 0], 
   [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta, gamma] , IdentityMat(5) );
end;
 
ACDim4Nr058 := function ( k1, k2, k3, k4, k5, k6)
local a, b, c, d, alfa, beta, gamma;
a :=[[1, 0, -k1, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, k1, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, -k1 - 2*k2 + 2*k3 - 2*k4, -k1 - 2*k3, 0, k2/2], [0, -1, 0, 0, 0], 
   [0, 0, -1, 0, 0], [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
beta :=[[-1, -k1/2, k1/2 + 2*k3, 0,  0], [0, -1, 0, 0, 1/2], 
   [0, 0, 1, 0, 1/2], [0, 0, 0, -1, 1/2], [0, 0, 0, 0, 1]];
gamma :=[[1, -k1 - 2*k2 + 2*k3 - 2*k4, -k1 - 2*k3, 
    4*k1 + 2*k2 + 2*k4 + 2*k5 - 2*k6, k6/2], [0, -1, 0, 0, 0], 
   [0, 0, -1, 0, 0], [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta, gamma] , IdentityMat(5) );
end;
 
ACDim4Nr060 := function ( k1, k2, k3, k4, k5, k6)
local a, b, c, d, alfa, beta, gamma;
a :=[[1, 0, -2*k1, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, 2*k1, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, -2*(k1 - k2 + k3 - k4), k1 - 2*k3, 0, 
    k2/2 + (k1 - k2 + k3 - k4)/2], [0, -1, 0, 0, 1/2], [0, 0, -1, 0, 0], 
   [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
beta :=[[-1, -k1, 2*k3, 0,  0], [0, -1, 0, 0, 0], [0, 0, 1, 0, 1/2], 
   [0, 0, 0, -1, 1/2], [0, 0, 0, 0, 1]];
gamma :=[[1, -2*(k1 - k2 + k3 - k4), -2*k3, 2*k3 + 2*k5 - 2*k6, k6/2], 
   [0, -1, 0, 0, 0], [0, 0, -1, 0, 0], [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta, gamma] , IdentityMat(5) );
end;
 
ACDim4Nr061 := function ( k1, k2, k3, k4, k5, k6)
local a, b, c, d, alfa, beta, gamma;
a :=[[1, 0, 0, -2*k1, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 2*k1, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[-1, -k1, 0, k1 + 2*k2,  0], [0, -1, 0, 0, 1/2], [0, 0, -1, 0, 0], 
   [0, 0, 0, 1, 1/2], [0, 0, 0, 0, 1]];
beta :=[[1, 7*k1 + 2*k2 - 2*k3 + 2*k4, 0, -2*k1 - 2*k2, 
    -(-2*k1 - 2*k2)/4 + k3/2], [0, -1, 0, 0, 0], [0, 0, 1, 0, 1/2], 
   [0, 0, 0, -1, 1/2], [0, 0, 0, 0, 1]];
gamma :=[[1, 8*k1 + 2*k2 - 2*k3 + 2*k4, 2*k1 + 2*k2 - 2*k6, -2*k1 - 2*k2, 
    (-k1 + k3 - k4 + k5)/2], [0, -1, 0, 0, 0], [0, 0, -1, 0, 0], 
   [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta, gamma] , IdentityMat(5) );
end;
 
ACDim4Nr061b := function ( k1, k2, k3, k4, k5, k6)
local a, b, c, d, alfa, beta, gamma;
a :=[[1, 0, -2*k1, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, 2*k1, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, -2*k3 - 2*k5 - 2*k6 + 2*(-k1 + k2 + k4 + k5 + k6), k1 - 2*k3, 0, 
    k2/2 - (-2*k3 - 2*k5 - 2*k6 + 2*(-k1 + k2 + k4 + k5 + k6))/4], 
   [0, -1, 0, 0, 1/2], [0, 0, -1, 0, 0], [0, 0, 0, 1, 1/2], [0, 0, 0, 0, 1]];
beta :=[[-1, -k1, 2*k3, 0,  0], [0, -1, 0, 0, 0], [0, 0, 1, 0, 1/2], 
   [0, 0, 0, -1, 1/2], [0, 0, 0, 0, 1]];
gamma :=[[1, -2*k3 - 2*k5 - 2*k6 + 2*(-k1 + k2 + k4 + k5 + k6), -2*k3, 
    2*k3 + 2*k6 - 2*(-k1 + k2 + k4 + k5 + k6), (-k1 + k2 + k4 + k5 + k6)/2], 
   [0, -1, 0, 0, 0], [0, 0, -1, 0, 0], [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta, gamma] , IdentityMat(5) );
end;
 
ACDim4Nr061c := function ( k1, k2, k3, k4, k5, k6)
local a, b, c, d, alfa, beta, gamma;
a :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, 0, 0, -2*k1, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, 2*k1, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[-1, 0, -k1, 2*k2, 2*k1 - k2/2], [0, -1, 0, 0, 1/2], 
   [0, 0, -1, 0, 0], [0, 0, 0, 1, 1/2], [0, 0, 0, 0, 1]];
beta :=[[-1, 0, -3*k1 - 2*k2 - 2*k6 + 2*(k1 + k2 + k3 + k6), k1, -k4/2], 
   [0, -1, 0, 0, 0], [0, 0, 1, 0, 1/2], [0, 0, 0, -1, 1/2], [0, 0, 0, 0, 1]];
gamma :=[[1, 2*k2 + 2*k5 - 2*(k1 + k2 + k3 + k6), 
    4*k1 + 2*k2 + 2*k6 - 2*(k1 + k2 + k3 + k6), -2*k2, (k1 + k2 + k3 + k6)/2], 
    [0, -1, 0, 0, 0], [0, 0, -1, 0, 0], [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta, gamma] , IdentityMat(5) );
end;
 
ACDim4Nr062 := function ( k1, k2, k3, k4, k5, k6)
local a, b, c, d, alfa, beta, gamma;
a :=[[1, 0, 0, -k1, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, k1, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[-1, -k1/2, 0, k1/2 + 2*k2,  0], [0, -1, 0, 0, 1/2], 
   [0, 0, -1, 0, 0], [0, 0, 0, 1, 1/2], [0, 0, 0, 0, 1]];
beta :=[[1, 3*k1 + 2*k2 - 2*k3 + 2*k4, 0, -k1 - 2*k2, k3/2], 
   [0, -1, 0, 0, 0], [0, 0, 1, 0, 1/2], [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
gamma :=[[1, 3*k1 + 2*k2 - 2*k3 + 2*k4, -2*k6, -k1 - 2*k2, (k3 - k4 + k5)/2], 
   [0, -1, 0, 0, 0], [0, 0, -1, 0, 0], [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta, gamma] , IdentityMat(5) );
end;
 
ACDim4Nr075 := function ( k1, k2, k3, k4)
local a, b, c, d, alfa;
a :=[[1, 0, -k1/2, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, k1/2, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k2, k3, 0, k4/4], [0, 0, -1, 0, 0], [0, 1, 0, 0, 0], 
   [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa] , IdentityMat(5) );
end;
 
ACDim4Nr076 := function ( k1, k2, k3, k4)
local a, b, c, d, alfa;
a :=[[1, 0, -k1/2, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, k1/2, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k2, k3, 0, k4/4], [0, 0, -1, 0, 0], [0, 1, 0, 0, 0], 
   [0, 0, 0, 1, 1/4], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa] , IdentityMat(5) );
end;
 
ACDim4Nr077 := function ( k1, k2, k3, k4)
local a, b, c, d, alfa;
a :=[[1, 0, -k1/2, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, k1/2, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k2, k3, 0, k4/4], [0, 0, -1, 0, 0], [0, 1, 0, 0, 0], 
   [0, 0, 0, 1, 1/2], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa] , IdentityMat(5) );
end;
 
ACDim4Nr079 := function ( k1, k2, k3, k4)
local a, b, c, d, alfa;
a :=[[1, 0, 0, -k1/2, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, 0, 0, k1/2, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, k1/2, -k1/2, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], 
   [0, 0, 0, 1, 1], [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k2, -k2, k3, k4/4], [0, 0, 1, 0, 0], [0, 0, 1, -1, 0], 
   [0, -1, 1, 0, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa] , IdentityMat(5) );
end;
 
ACDim4Nr080 := function ( k1, k2, k3, k4)
local a, b, c, d, alfa;
a :=[[1, 0, 0, -k1/2, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, 0, 0, k1/2, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, k1/2, -k1/2, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], 
   [0, 0, 0, 1, 1], [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, -k1/4 + k2, k1/4 - k2, k3, k1/16 - k2/4 + k3/4 + k4/4], 
   [0, 0, 1, 0, 1/2], [0, 0, 1, -1, 0], [0, -1, 1, 0, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa] , IdentityMat(5) );
end;
 
ACDim4Nr081 := function ( k1, k2, k3, k4, k5)
local a, b, c, d, alfa;
a :=[[1, 0, -k1/2, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, k1/2, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k2, k3, k4, k5/4], [0, 0, 1, 0, 0], [0, -1, 0, 0, 0], 
   [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa] , IdentityMat(5) );
end;
 
ACDim4Nr082 := function ( k1, k2, k3, k4, k5)
local a, b, c, d, alfa;
a :=[[1, 0, 0, -k1/2, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, 0, 0, k1/2, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, k1/2, -k1/2, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], 
   [0, 0, 0, 1, 1], [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k2, k3, k4, k5/4], [0, 0, -1, 0, 0], [0, 0, -1, 1, 0], 
   [0, 1, -1, 0, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa] , IdentityMat(5) );
end;
 
ACDim4Nr083 := function ( k1, k2, k3, k4, k5, k6)
local a, b, c, d, alfa, beta;
a :=[[1, 0, -k1/2, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, k1/2, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k2, k3, 0, k4/4], [0, 0, -1, 0, 0], [0, 1, 0, 0, 0], 
   [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
beta :=[[1, k2 + k3, -k2 + k3, k5, k6/2], [0, -1, 0, 0, 0], [0, 0, -1, 0, 0], 
   [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr084 := function ( k1, k2, k3, k4, k5, k6)
local a, b, c, d, alfa, beta;
a :=[[1, 0, -k1/2, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, k1/2, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k2, k3, 0, k4/4], [0, 0, -1, 0, 0], [0, 1, 0, 0, 0], 
   [0, 0, 0, 1, 1/2], [0, 0, 0, 0, 1]];
beta :=[[1, k2 + k3, -k2 + k3, -2*k6, k5/2], [0, -1, 0, 0, 0], 
   [0, 0, -1, 0, 0], [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr085 := function ( k1, k2, k3, k4, k5, k6)
local a, b, c, d, alfa, beta;
a :=[[1, 0, -k1, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, k1, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k2, -k1/2 + k2 - 2*k6, 0, 
    -k1/8 + k2/4 + k3/4 - (-k1 + k2 - 2*k6)/4], [0, 0, -1, 0, 0], 
   [0, 1, 0, 0, 1/2], [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
beta :=[[1, 2*k2 - 2*k6, -2*k6, k4, k5/2], [0, -1, 0, 0, 0], 
   [0, 0, -1, 0, 0], [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr086 := function ( k1, k2, k3, k4, k5, k6)
local a, b, c, d, alfa, beta;
a :=[[1, 0, -k1, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, k1, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k2, k1/2 + k3, 0, -k1/8 + k2/4 - k3/4 + k4/4], [0, 0, -1, 0, 0], 
   [0, 1, 0, 0, 1/2], [0, 0, 0, 1, 1/2], [0, 0, 0, 0, 1]];
beta :=[[1, k1 + k2 + k3, k1 - k2 + k3, -k1 + k2 - k3 - 2*k6, k5/2], 
   [0, -1, 0, 0, 0], [0, 0, -1, 0, 0], [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr087 := function ( k1, k2, k3, k4, k5, k6)
local a, b, c, d, alfa, beta;
a :=[[1, 0, 0, -k1/2, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, 0, 0, k1/2, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, k1/2, -k1/2, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], 
   [0, 0, 0, 1, 1], [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k2, -k2, k3, k4/4], [0, 0, 1, 0, 0], [0, 0, 1, -1, 0], 
   [0, -1, 1, 0, 0], [0, 0, 0, 0, 1]];
beta :=[[1, k5, -2*k2 + 2*k3 + k5, 2*k2 - k5, k6/2], [0, -1, 0, 0, 0], 
   [0, 0, -1, 0, 0], [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr088 := function ( k1, k2, k3, k4, k5, k6)
local a, b, c, d, alfa, beta;
a :=[[1, 0, 0, -k1/2, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, 0, 0, k1/2, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, k1/2, -k1/2, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], 
   [0, 0, 0, 1, 1], [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k2, -k2, -k1/4 + k3, -(-k1/4 + k2 + k3 - k4)/4], [0, 0, 1, 0, 0], 
   [0, 0, 1, -1, 0], [0, -1, 1, 0, 1/2], [0, 0, 0, 0, 1]];
beta :=[[1, 2*k2 + 2*k6, -k1 + 2*k3 + 2*k6, -2*k6, k5/2], [0, -1, 0, 0, 0], 
   [0, 0, -1, 0, 0], [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr103 := function ( k1, k2, k3, k4, k5)
local a, b, c, d, alfa, beta;
a :=[[1, 0, -k1/2, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, k1/2, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k2, k3, 0, k4/4], [0, 0, -1, 0, 0], [0, 1, 0, 0, 0], 
   [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
beta :=[[-1, -k2 - k3, 0, 2*k5,  0], [0, 1, 0, 0, 0], [0, 0, -1, 0, 0], 
   [0, 0, 0, 1, 1/2], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr104 := function ( k1, k2, k3, k4, k5)
local a, b, c, d, alfa, beta;
a :=[[1, 0, -k1, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, k1, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k1/2 + k2, -k1 + k2 + 2*k3 + 2*k5, 0, 
    -k1/8 - k2/4 + k3/4 - (-k1 + k2 + 2*k3 + 2*k5)/4], [0, 0, -1, 0, 1/2], 
   [0, 1, 0, 0, 0], [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
beta :=[[-1, -2*k2 - 2*k3 - 2*k5, k1/2, 2*k2 + 2*k3 + 2*k4 + 2*k5,  0], 
   [0, 1, 0, 0, 1/2], [0, 0, -1, 0, 0], [0, 0, 0, 1, 1/2], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr106 := function ( k1, k2, k3, k4, k5)
local a, b, c, d, alfa, beta;
a :=[[1, 0, -k1, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, k1, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k1/2 + k2, -k1 - k2 - 2*k5, 0, 
    -k1/8 - k2/4 + k3/4 - (-k1 - k2 - 2*k5)/4], [0, 0, -1, 0, 1/2], 
   [0, 1, 0, 0, 0], [0, 0, 0, 1, 1/2], [0, 0, 0, 0, 1]];
beta :=[[-1, 2*k5, k1/2, -2*k4,  0], [0, 1, 0, 0, 1/2], [0, 0, -1, 0, 0], 
   [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr110 := function ( k1, k2, k3, k4, k5)
local a, b, c, d, alfa, beta;
a :=[[1, 0, 0, -k1, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, 0, 0, k1, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, k1, -k1, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, 4*k1 - 4*k2 + 2*k3 - 3*k4 + 2*k5, 
    -4*k1 + 4*k2 - 2*k3 + 3*k4 - 2*k5, -k1/2 + k2, 
    -(-k1/2 + k2 - k3 - (3*(-4*k1 + 4*k2 - 2*k3 + 3*k4 - 2*k5))/2 - 
        (4*k1 - 4*k2 + 2*k3 - 3*k4 + 2*k5)/2)/4], [0, 0, 1, 0, 0], 
   [0, 0, 1, -1, 0], [0, -1, 1, 0, 1/2], [0, 0, 0, 0, 1]];
beta :=[[-1, -k4, 2*(k1 - k2 - k4) + k4, k4,  0], [0, 0, 1, -1, 1/2], 
   [0, 0, 1, 0, 1/2], [0, -1, 1, 0, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr114 := function ( k1, k2, k3, k4, k5)
local a, b, c, d, alfa, beta;
a :=[[1, 0, -k1, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, k1, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, -k1/2 + k2, k1 - k2 - 2*k4, 2*k1 - 2*k2 + 2*k3 - 2*k4 + 2*k5, 
    -(k1/2 + k3 + 2*k5)/4], [0, 0, 1, 0, 1/2], [0, -1, 0, 0, 0], 
   [0, 0, 0, -1, 1/2], [0, 0, 0, 0, 1]];
beta :=[[-1, -k1/2, 2*k4, 0,  0], [0, -1, 0, 0, 0], [0, 0, 1, 0, 1/2], 
   [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr143 := function ( k1, k2, k3, k4)
local a, b, c, d, alfa;
a:= [[1, 0, -k1/2, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b:= [[1, k1/2, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c:= [[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d:= [[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa:= [[1, k2, -k1/2 + k3, 0, k4/3], [0, 0, -1, 0, 0], [0, 1, -1, 0, 0], 
   [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa] , IdentityMat(5) );
end;
 
ACDim4Nr144 := function ( k1, k2, k3, k4)
local a, b, c, d, alfa;
a :=[[1, 0, -k1/2, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, k1/2, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k2, -k1/2 + k3, 0, k4/3], [0, 0, -1, 0, 0], [0, 1, -1, 0, 0], 
   [0, 0, 0, 1, 1/3], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa] , IdentityMat(5) );
end;
 
ACDim4Nr146 := function ( k1, k2, k3, k4)
local a, b, c, d, alfa;
a :=[[1, 0, -k1/2, k1/2, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], 
   [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
b :=[[1, k1/2, 0, -k1/2, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], 
   [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
c :=[[1, -k1/2, k1/2, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], 
   [0, 0, 0, 1, 1], [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k2, k3, -k2 - k3, k4/3], [0, 0, 0, 1, 0], [0, 1, 0, 0, 0], 
   [0, 0, 1, 0, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa] , IdentityMat(5) );
end;
 
ACDim4Nr147 := function ( k1, k2, k3, k4, k5)
local a, b, c, d, alfa;
a :=[[1, 0, -k1/2, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, k1/2, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k2, -k1/2 + k3, k4, k5/6], [0, 0, 1, 0, 0], [0, -1, 1, 0, 0], 
   [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa] , IdentityMat(5) );
end;
 
ACDim4Nr148 := function ( k1, k2, k3, k4, k5)
local a, b, c, d, alfa;
a :=[[1, 0, -k1/2, k1/2, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], 
   [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
b :=[[1, k1/2, 0, -k1/2, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], 
   [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
c :=[[1, -k1/2, k1/2, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], 
   [0, 0, 0, 1, 1], [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k2, k3, k4, k5/6], [0, 0, 0, -1, 0], [0, -1, 0, 0, 0], 
   [0, 0, -1, 0, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa] , IdentityMat(5) );
end;
 
ACDim4Nr158 := function ( k1, k2, k3, k4, k5)
local a, b, c, d, alfa, beta;
a :=[[1, 0, -k1/2, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, k1/2, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k2, -k1/2 + k3, 0, k4/3], [0, 0, -1, 0, 0], [0, 1, -1, 0, 0], 
   [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
beta :=[[-1, -k2, k2, 2*k5,  0], [0, 0, -1, 0, 0], [0, -1, 0, 0, 0], 
   [0, 0, 0, 1, 1/2], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr159 := function ( k1, k2, k3, k4, k5)
local a, b, c, d, alfa, beta;
a :=[[1, 0, -k1/2, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, k1/2, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k1 - 2*k2 + 3*k4, -k1/2 + k2, 0, k3/3], [0, 0, -1, 0, 0], 
   [0, 1, -1, 0, 0], [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
beta :=[[-1, -k4, -k4, 2*k5,  0], [0, 0, 1, 0, 0], [0, 1, 0, 0, 0], 
   [0, 0, 0, 1, 1/2], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr161 := function ( k1, k2, k3, k4, k5)
local a, b, c, d, alfa, beta;
a :=[[1, 0, -k1/2, k1/2, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], 
   [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
b :=[[1, k1/2, 0, -k1/2, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], 
   [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
c :=[[1, -k1/2, k1/2, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], 
   [0, 0, 0, 1, 1], [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k1/4 + k2, k3, -k1/4 - k2 - k3, 
    -((5*k1)/8 + k2 + (-k2 - k3)/2 + (3*k3)/2 - k4)/3], [0, 0, 0, 1, 1/2], 
   [0, 1, 0, 0, 1/2], [0, 0, 1, 0, 0], [0, 0, 0, 0, 1]];
beta :=[[-1, -k1/4 - k2 - 2*k3 + 2*k5, (-3*k1)/4 - k2 - 2*k3 + 2*k5, 2*k5, 
     0], [0, 0, 1, 0, 0], [0, 1, 0, 0, 0], [0, 0, 0, 1, 1/2], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr168 := function ( k1, k2, k3, k4)
local a, b, c, d, alfa;
a :=[[1, 0, -k1/2, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, k1/2, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k2, -k1/2 + k3, 0, k4/6], [0, 0, 1, 0, 0], [0, -1, 1, 0, 0], 
   [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa] , IdentityMat(5) );
end;
 
ACDim4Nr169 := function ( k1, k2, k3, k4)
local a, b, c, d, alfa;
a :=[[1, 0, -k1/2, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, k1/2, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k2, -k1/2 + k3, 0, k4/6], [0, 0, 1, 0, 0], [0, -1, 1, 0, 0], 
   [0, 0, 0, 1, 5/6], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa] , IdentityMat(5) );
end;
 
ACDim4Nr172 := function ( k1, k2, k3, k4)
local a, b, c, d, alfa;
a :=[[1, 0, -k1/2, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, k1/2, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k2, -k1/2 + k3, 0, k4/6], [0, 0, 1, 0, 0], [0, -1, 1, 0, 0], 
   [0, 0, 0, 1, 1/3], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa] , IdentityMat(5) );
end;
 
ACDim4Nr173 := function ( k1, k2, k3, k4)
local a, b, c, d, alfa;
a :=[[1, 0, -k1/2, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, k1/2, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k2, -k1/2 + k3, 0, k4/6], [0, 0, 1, 0, 0], [0, -1, 1, 0, 0], 
   [0, 0, 0, 1, 1/2], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa] , IdentityMat(5) );
end;
 
ACDim4Nr174 := function ( k1, k2, k3, k4, k5)
local a, b, c, d, alfa;
a :=[[1, 0, -k1/2, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, k1/2, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k2, -k1/2 + k3, k4, k5/6], [0, 0, -1, 0, 0], [0, 1, -1, 0, 0], 
   [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa] , IdentityMat(5) );
end;
 
ACDim4Nr175 := function ( k1, k2, k3, k4, k5, k6)
local a, b, c, d, alfa, beta;
a :=[[1, 0, -k1/2, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, k1/2, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k2, -k1/2 + k3, 0, k4/6], [0, 0, 1, 0, 0], [0, -1, 1, 0, 0], 
   [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
beta :=[[1, k1 - 2*k3, -k1 + 2*k2 + 2*k3, k5, k6/2], [0, -1, 0, 0, 0], 
   [0, 0, -1, 0, 0], [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr176 := function ( k1, k2, k3, k4, k5, k6)
local a, b, c, d, alfa, beta;
a :=[[1, 0, -k1/2, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, k1/2, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k2, -k1/2 + k3, 0, k4/6], [0, 0, 1, 0, 0], [0, -1, 1, 0, 0], 
   [0, 0, 0, 1, 1/2], [0, 0, 0, 0, 1]];
beta :=[[1, k1 - 2*k3, -k1 + 2*k2 + 2*k3, 2*k6, k5/2], [0, -1, 0, 0, 0], 
   [0, 0, -1, 0, 0], [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4Nr184 := function ( k1, k2, k3, k4, k5)
local a, b, c, d, alfa, beta;
a :=[[1, 0, -k1/2, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
b :=[[1, k1/2, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
c :=[[1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], 
   [0, 0, 0, 0, 1]];
d :=[[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
   [0, 0, 0, 0, 1]];
alfa :=[[1, k2, -k1/2 + k3, 0, k4/6], [0, 0, 1, 0, 0], [0, -1, 1, 0, 0], 
   [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
beta :=[[-1, -k1 + k2 + 2*k3, k1 - k2 - 2*k3, 2*k5,  0], [0, 0, -1, 0, 0], 
   [0, -1, 0, 0, 0], [0, 0, 0, 1, 1/2], [0, 0, 0, 0, 1]];
return Group( [a, b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4NrB1 := function ( k, k1, k2, k3)
local a, b, c, d;
a:= [[1, (-2*k2)/3, 0, -k1/2 - (2*k*k3)/3 + (2*k*(k2 + k3))/3, 0], 
     [0, 1, 0, -k/2, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
b:= [[1, (-2*k3)/3, k1/2 - (2*k*k3)/3, 0, 0], [0, 1, k/2, 0, 0], 
     [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], [0, 0, 0, 0, 1]];
c:= [[1, 0, k2/3, k3/3, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], 
     [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
d:= [[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
     [0, 0, 0, 0, 1]];
return Group( [a , b, c, d] , IdentityMat(5) );
end;
 
ACDim4NrB2 := function ( k, k1, k2, k3)
local a, b, c, d, alfa;
a:= [[1, (-4*k1)/3, 0, (2*k*k1)/3 + (2*k*k2)/3 - 2*k*k3 + 
       (-4*k*k1 - (16*k*k2)/3 - 2*k*k3 + 2*(2*k*k1 + 2*k*k2 + 2*k*k3))/2, 0], 
     [0, 1, 0, -k, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
b:= [[1, (-4*k2)/3, (-4*k*k1 - (16*k*k2)/3 - 2*k*k3 + 
        2*(2*k*k1 + 2*k*k2 + 2*k*k3))/2, 0, 0], [0, 1, k, 0, 0], 
     [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], [0, 0, 0, 0, 1]];
c:= [[1, 0, (2*k1)/3, (2*k2)/3, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], 
     [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
d:= [[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
     [0, 0, 0, 0, 1]];
alfa:= [[-1, 2*k3, -k1/3, -k2/3, 0], [0, 1, 0, 0, 1/2], [0, 0, -1, 0, 0], 
     [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
return Group( [a , b, c, d, alfa] , IdentityMat(5) );
end;
 
ACDim4NrB3c := function (l, k1, k2, k3, k4)
local a, b, c, d, alfa;
a:= [[1, 0, 0, (k1*l)/3 + k3*l + ((-8*k1*l)/3 + k3*l + 2*(k1*l - k3*l))/2, 
      0], [0, 1, 0, -l, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
b:= [[1, (-2*k1)/3, ((-8*k1*l)/3 + k3*l + 2*(k1*l - k3*l))/2, -k2, 0], 
     [0, 1, l, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], [0, 0, 0, 0, 1]];
c:= [[1, 0, 0, k1/3, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
     [0, 0, 0, 0, 1]];
d:= [[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
     [0, 0, 0, 0, 1]];
alfa:= [[1, k3, 0, 0, k4/2], [0, -1, 0, 0, 0], [0, 0, 1, 0, 0], 
     [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
return Group( [a , b, c, d, alfa] , IdentityMat(5) );
end;
 
ACDim4NrB3b := function (l, k1, k2, k3, k4)
local a, b, c, d, alfa;
a:= [[1, 0, 0, k1 + (2*k1*l)/3 - 2*k2*l + ((2*k1)/3 - (16*k1*l)/3 - 2*k2*l + 
         2*(-k1 + 2*k1*l + 2*k2*l))/2, 0], [0, 1, 0, -l, 0], [0, 0, 1, 0, 1], 
     [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
b:= [[1, (-4*k1)/3, ((2*k1)/3 - (16*k1*l)/3 - 2*k2*l + 
        2*(-k1 + 2*k1*l + 2*k2*l))/2, -k3, 0], [0, 1, l, 0, 0], 
     [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], [0, 0, 0, 0, 1]];
c:= [[1, 0, 0, (2*k1)/3, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], 
     [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
d:= [[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
     [0, 0, 0, 0, 1]];
alfa:= [[1, -2*k2, -k2, 0, k4/2], [0, -1, -1, 0, 0], [0, 0, 1, 0, 0], 
     [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
return Group( [a , b, c, d, alfa] , IdentityMat(5) );
end;
 
ACDim4NrB3 := function (l, k1, k2, k3, k4)
local a, b, c, d, alfa;
a:= [[1, 0, 0, (2*k1)/3 + (k1*l)/3 + (-k1 - (2*k1*l)/3)/2, 0], 
     [0, 1, 0, (-1 - 2*l)/2, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], 
     [0, 0, 0, 0, 1]];
b:= [[1, (-2*k1)/3, (-k1 - (2*k1*l)/3)/2, -k3, 0], [0, 1, (1 + 2*l)/2, 0, 0], 
     [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], [0, 0, 0, 0, 1]];
c:= [[1, 0, 0, k1/3, -k2], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
     [0, 0, 0, 0, 1]];
d:= [[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
     [0, 0, 0, 0, 1]];
alfa:= [[1, 0, 0, 0, k4/2], [0, -1, -1, 0, 0], [0, 0, 1, 0, 0], 
     [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
return Group( [a , b, c, d, alfa] , IdentityMat(5) );
end;
 
ACDim4NrB4 := function (k, k1, k2, k3, k4)
local a, b, c, d, alfa, beta;
a:= [[1, 0, 0, (k*k1)/3 + k*k3 + ((-2*k*k1)/3 - k*k3)/2, -k4], 
     [0, 1, 0, -k, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
b:= [[1, (-2*k1)/3, ((-2*k*k1)/3 - k*k3)/2, -(k*k1)/2 - k2 + (3*k*k3)/4, 0], 
     [0, 1, k, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], [0, 0, 0, 0, 1]];
c:= [[1, 0, 0, k1/3, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
     [0, 0, 0, 0, 1]];
d:= [[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
     [0, 0, 0, 0, 1]];
alfa:= [[1, k3, 0, 0, 0], [0, -1, 0, k/2, 0], [0, 0, 1, 0, 1/2], 
     [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
return Group( [a , b, c, d, alfa] , IdentityMat(5) );
end;
 
ACDim4NrB4b := function (k, k1, k2, k3)
local a, b, c, d, alfa;
a:= [[1, (4*k1)/3, 0, (-5*k*k1)/3 + 2*k2 - 2*((-2*k*k1)/3 + k2), -k3], 
     [0, 1, 0, -k, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
b:= [[1, 0, -2*((-2*k*k1)/3 + k2), 0, 0], [0, 1, k, 0, 0], [0, 0, 1, 0, 0], 
     [0, 0, 0, 1, 1], [0, 0, 0, 0, 1]];
c:= [[1, 0, (-2*k1)/3, 0, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], 
     [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
d:= [[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
     [0, 0, 0, 0, 1]];
alfa:= [[-1, (-2*k1)/3, 0, 0, 0], [0, -1, 0, k/2, 0], [0, 0, 1, 0, 1/2], 
     [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
return Group( [a , b, c, d, alfa] , IdentityMat(5) );
end;
 
ACDim4NrB5 := function (l, k1, k2, k3, k4)
local a, b, c, d, alfa;
a:= [[1, (-2*k1)/3, 0, k3*l, k2], [0, 1, 0, -l, 0], [0, 0, 1, 0, 1], 
     [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
b:= [[1, (2*k1)/3, 0, 0, 0], [0, 1, l, 0, 0], [0, 0, 1, 0, 0], 
     [0, 0, 0, 1, 1], [0, 0, 0, 0, 1]];
c:= [[1, 0, k1/3, -k1/3, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], 
     [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
d:= [[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
     [0, 0, 0, 0, 1]];
alfa:= [[1, k3, 0, 0, k4/2], [0, -1, 0, 0, 0], [0, 0, 0, 1, 0], 
     [0, 0, 1, 0, 0], [0, 0, 0, 0, 1]];
return Group( [a , b, c, d, alfa] , IdentityMat(5) );
end;
 
ACDim4NrB5b := function (l, k1, k2, k3, k4)
local a, b, c, d, alfa;
a:= [[1, (-2*k1)/3, 0, k3*(1 + 2*l), k2], [0, 1, 0, (-1 - 2*l)/2, 0], 
     [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
b:= [[1, (2*k1)/3, 0, 0, 0], [0, 1, (1 + 2*l)/2, 0, 0], [0, 0, 1, 0, 0], 
     [0, 0, 0, 1, 1], [0, 0, 0, 0, 1]];
c:= [[1, 0, k1/3, -k1/3, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], 
     [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
d:= [[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
     [0, 0, 0, 0, 1]];
alfa:= [[1, 2*k3, 0, 0, k4/2], [0, -1, 0, 0, 0], [0, 0, 0, 1, 0], 
     [0, 0, 1, 0, 0], [0, 0, 0, 0, 1]];
return Group( [a , b, c, d, alfa] , IdentityMat(5) );
end;
 
ACDim4NrB7 := function (l, k1, k2, k3, k4)
local a, b, c, d, alfa, beta;
a:= [[1, 0, 0, (4*k1*l)/3 - 4*k2*l + ((-8*k1*l)/3 + 4*k2*l)/2, 0], 
     [0, 1, 0, -2*l, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
b:= [[1, (-4*k1)/3, ((-8*k1*l)/3 + 4*k2*l)/2, 0, (5*k1)/6 - 2*k2 + 
       ((-2*k1)/3 + 2*k2)/2 - k4], [0, 1, 2*l, 0, 0], [0, 0, 1, 0, 0], 
     [0, 0, 0, 1, 1], [0, 0, 0, 0, 1]];
c:= [[1, 0, 0, (2*k1)/3, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], 
     [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
d:= [[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
     [0, 0, 0, 0, 1]];
alfa:= [[-1, 2*k2, 0, -k1/3, 0], [0, 1, 0, 0, 1/2], [0, 0, -1, 0, 0], 
     [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
beta:= [[1, (2*k1)/3 - 2*k2, -(((2*k1)/3 - 2*k2)*l)/2, 2*k3, 0], 
     [0, -1, l, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, -1, 1/2], [0, 0, 0, 0, 1]];
return Group( [a , b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4NrB7b := function (l, k1, k2, k3, k4)
local a, b, c, d, alfa, beta;
a:= [[1, 0, 0, (4*k1*(1 + 2*l))/3 - 2*k2*(1 + 2*l) + 
       ((-8*k1*(1 + 2*l))/3 + 2*k2*(1 + 2*l))/2, 0], [0, 1, 0, -1 - 2*l, 0], 
     [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
b:= [[1, (-8*k1)/3, ((-8*k1*(1 + 2*l))/3 + 2*k2*(1 + 2*l))/2, 0, 
      (5*k1)/3 - 2*k2 + ((-4*k1)/3 + 2*k2)/2 - k4], [0, 1, 1 + 2*l, 0, 0], 
     [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], [0, 0, 0, 0, 1]];
c:= [[1, 0, 0, (4*k1)/3, 0], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], 
     [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
d:= [[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
     [0, 0, 0, 0, 1]];
alfa:= [[-1, 2*k2, 0, (-2*k1)/3, 0], [0, 1, 0, 0, 1/2], [0, 0, -1, 0, 0], 
     [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
beta:= [[1, (4*k1)/3 - 2*k2, -(((4*k1)/3 - 2*k2)*(1 + 2*l))/4, 2*k3, 0], 
     [0, -1, (1 + 2*l)/2, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, -1, 1/2], 
     [0, 0, 0, 0, 1]];
return Group( [a , b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4NrB8 := function (k, k1, k2, k3, k4)
local a, b, c, d, alfa, beta;
a:= [[1, 0, 0, -2*k*(k1 - 2*k2) - 8*k*k2 + (8*k*(2*(k1 - 2*k2) + 4*k2))/3 + 
       (-4*k*k2 - (14*k*(2*(k1 - 2*k2) + 4*k2))/3 + 
         2*(2*k*(k1 - 2*k2) + 8*k*k2))/2, 
      (k*(k1 + (-2*(k1 - 2*k2) - 4*k2)/6 - 2*k2))/4 - k3 + 
       (k1 + (17*k*(k1 - 2*k2))/3 - 3*k2 + (34*k*k2)/3 + (-k1 + 2*k2)/2 + 
         (-2*k*(k1 - 2*k2) - 8*k*k2)/2 + (k1 - 2*k*(k1 - 2*k2) - 6*k*k2)/2 + 
         2*k3 - 2*k4)/2], [0, 1, 0, -2*k, 0], [0, 0, 1, 0, 1], 
     [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
b:= [[1, (-2*(2*(k1 - 2*k2) + 4*k2))/3, 
      (-4*k*k2 - (14*k*(2*(k1 - 2*k2) + 4*k2))/3 + 
        2*(2*k*(k1 - 2*k2) + 8*k*k2))/2, k1 + (-2*(k1 - 2*k2) - 4*k2)/3 - 
       2*k*(k1 - 2*k2) - 2*k*k2 + (4*k*(2*(k1 - 2*k2) + 4*k2))/3 + 
       ((-2*(k1 - 2*k2) - 4*k2)/3 - 4*k*k2)/2, 0], [0, 1, 2*k, 0, 0], 
     [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], [0, 0, 0, 0, 1]];
c:= [[1, 0, 0, (2*(k1 - 2*k2) + 4*k2)/3, 0], [0, 1, 0, 0, 1], 
     [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
d:= [[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
     [0, 0, 0, 0, 1]];
alfa:= [[-1, 2*k2, 2*k*k2, ((-2*(k1 - 2*k2) - 4*k2)/3 - 4*k*k2)/2, 0], 
     [0, 1, 2*k, -2*k, 1/2], [0, 0, -1, 0, 0], [0, 0, 0, -1, 0], 
     [0, 0, 0, 0, 1]];
beta:= [[1, k1 + (-2*(k1 - 2*k2) - 4*k2)/6 - 2*k2, 
      (k*(k1 + (-2*(k1 - 2*k2) - 4*k2)/6 - 2*k2))/2, 
      k1 + (17*k*(k1 - 2*k2))/3 - 3*k2 + (34*k*k2)/3 + (-k1 + 2*k2)/2 + 
       (-2*k*(k1 - 2*k2) - 8*k*k2)/2 + (k1 - 2*k*(k1 - 2*k2) - 6*k*k2)/2 + 
       2*k3 - 2*k4, 0], [0, -1, -k, k, 0], [0, 0, 1, 0, 1/2], 
     [0, 0, 0, -1, 1/2], [0, 0, 0, 0, 1]];
return Group( [a , b, c, d, alfa, beta] , IdentityMat(5) );
end;
 
ACDim4NrB8b := function (k, k1, k2, k3, k4)
local a, b, c, d, alfa, beta;
a:= [[1, (4*k1)/3, (-2*k1)/3 + (4*k*k1)/3 + 
       ((-16*k*k1)/3 + 8*k*k2 - 2*(-2*k*k1 + 4*k*k2))/2 + 
       2*(k1/3 - (2*k*k1)/3 + ((16*k*k1)/3 - 8*k*k2 + 
       2*(-2*k*k1 + 4*k*k2))/ 2), (-10*k*k1)/3 + ((16*k*k1)/3 - 8*k*k2 + 
       2*(-2*k*k1 + 4*k*k2))/2, 
      ((8*k*k1)/3 - 2*k*k2 + (-2*k*k1 + 4*k*k2)/2 + 
         ((-16*k*k1)/3 + 8*k*k2 - 2*(-2*k*k1 + 4*k*k2))/2)/2 - k3], 
     [0, 1, 0, -2*k, 0], [0, 0, 1, 0, 1], [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
b:= [[1, 0, ((16*k*k1)/3 - 8*k*k2 + 2*(-2*k*k1 + 4*k*k2))/2, 0, 
      (-2*k1)/3 - (2*k*k1)/3 + k2 + 4*k*k2 + (2*k*k1 - 4*k*k2)/2 + 
       ((-16*k*k1)/3 + 8*k*k2 - 2*(-2*k*k1 + 4*k*k2))/4 + 
     (k1/3 - (2*k*k1)/3 + ((16*k*k1)/3 - 8*k*k2 + 2*(-2*k*k1 + 4*k*k2))/2)/ 2 
     + ((-8*k*k1)/3 + 2*k*k2 + (2*k*k1 - 4*k*k2)/2 + 
         ((16*k*k1)/3 - 8*k*k2 + 2*(-2*k*k1 + 4*k*k2))/2)/2 + k3 + k4], 
     [0, 1, 2*k, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 1], [0, 0, 0, 0, 1]];
c:= [[1, 0, (-2*k1)/3, 0, -k2], [0, 1, 0, 0, 1], [0, 0, 1, 0, 0], 
     [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]];
d:= [[1, 0, 0, 0, 1], [0, 1, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], 
     [0, 0, 0, 0, 1]];
alfa:= [[-1, 0, k1/3 - (2*k*k1)/3 + ((16*k*k1)/3 - 8*k*k2 + 
         2*(-2*k*k1 + 4*k*k2))/2, 0, 0], [0, 1, 2*k, -2*k, 1/2], 
     [0, 0, -1, 0, 0], [0, 0, 0, -1, 0], [0, 0, 0, 0, 1]];
beta:= [[-1, (-2*k1)/3, 0, (8*k*k1)/3 - 2*k*k2 + (-2*k*k1 + 4*k*k2)/2 + 
       ((-16*k*k1)/3 + 8*k*k2 - 2*(-2*k*k1 + 4*k*k2))/2, 0], 
     [0, -1, -k, k, 0], [0, 0, 1, 0, 1/2], [0, 0, 0, -1, 1/2], 
     [0, 0, 0, 0, 1]];
return Group( [a , b, c, d, alfa, beta] , IdentityMat(5) );
end;

#############################################################################
##
#V ACDim4Funcs
#V ACDim4Param
#V ACDim4Types
##

#############################################################################
##
## some small helpers
##
ACDim4Funcs := [ ACDim4Nr001, ACDim4Nr002, ACDim4Nr003, ACDim4Nr004,
ACDim4Nr004b, ACDim4Nr005, ACDim4Nr006, ACDim4Nr007, ACDim4Nr007b,
ACDim4Nr008, ACDim4Nr009, ACDim4Nr009b, ACDim4Nr010, ACDim4Nr011,
ACDim4Nr012, ACDim4Nr013, ACDim4Nr014,
ACDim4Nr014b, ACDim4Nr015, ACDim4Nr018, ACDim4Nr019, ACDim4Nr019b,
ACDim4Nr019c, ACDim4Nr026, ACDim4Nr027, ACDim4Nr029, ACDim4Nr029b,
ACDim4Nr029c, ACDim4Nr030, ACDim4Nr031, ACDim4Nr032, ACDim4Nr033,
ACDim4Nr033b, ACDim4Nr033c, ACDim4Nr034, ACDim4Nr036, ACDim4Nr037,
ACDim4Nr041, ACDim4Nr043, ACDim4Nr045, ACDim4Nr055, ACDim4Nr056,
ACDim4Nr058, ACDim4Nr060, ACDim4Nr061, ACDim4Nr061b, ACDim4Nr061c,
ACDim4Nr062, ACDim4Nr075, ACDim4Nr076, ACDim4Nr077, ACDim4Nr079,
ACDim4Nr080, ACDim4Nr081, ACDim4Nr082, ACDim4Nr083, ACDim4Nr084, ACDim4Nr085,
ACDim4Nr086, ACDim4Nr087, ACDim4Nr088, ACDim4Nr103, ACDim4Nr104, ACDim4Nr106,
ACDim4Nr110, ACDim4Nr114, ACDim4Nr143, ACDim4Nr144, ACDim4Nr146, ACDim4Nr147,
ACDim4Nr148, ACDim4Nr158, ACDim4Nr159, ACDim4Nr161, ACDim4Nr168, ACDim4Nr169,
ACDim4Nr172, ACDim4Nr173, ACDim4Nr174, ACDim4Nr175, ACDim4Nr176, ACDim4Nr184,
ACDim4NrB1, ACDim4NrB2, ACDim4NrB3c, ACDim4NrB3b, ACDim4NrB3, ACDim4NrB4,
ACDim4NrB4b, ACDim4NrB5, ACDim4NrB5b, ACDim4NrB7, ACDim4NrB7b, ACDim4NrB8,
ACDim4NrB8b ];
MakeReadOnlyGlobal( "ACDim4Funcs" );

#############################################################################
ACDim4Types := [
"001", "002", "003", "004", "004b", "005", "006", "007", "007b", "008",
"009", "009b", "010", "011", "012", "013", "014", "014b", "015", "018",
"019", "019b", "019c", "026", "027", "029", "029b", "029c", "030", "031",
"032", "033", "033b", "033c", "034", "036", "037", "041", "043", "045",
"055", "056", "058", "060", "061", "061b", "061c", "062", "075", "076",
"077", "079", "080", "081", "082", "083", "084", "085", "086", "087", "088",
"103", "104", "106", "110", "114", "143", "144", "146", "147", "148", "158",
"159", "161", "168", "169", "172", "173", "174", "175", "176", "184", "B1",
"B2", "B3c", "B3b", "B3", "B4", "B4b", "B5", "B5b", "B7", "B7b", "B8", "B8b"
];
MakeReadOnlyGlobal( "ACDim4Types" );

#############################################################################
ACDim4Param :=
[ 3, 7, 4, 4, 3, 4, 3, 3, 4, 3, 3, 4, 6, 6, 6, 6, 6, 6, 6, 4, 4, 4, 4, 4, 5,
  4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 4, 4,
  4, 4, 4, 5, 5, 6, 6, 6, 6, 6, 6, 5, 5, 5, 5, 5, 4, 4, 4, 5, 5, 5, 5, 5, 4,
  4, 4, 4, 5, 6, 6, 5, 4, 4, 5, 5, 5, 5, 4, 5, 5, 5, 5, 5, 5 ];
MakeReadOnlyGlobal( "ACDim4Param" );

