; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

declare i1 @barrier()
declare void @llvm.assume(i1)
declare void @use.i8(i8)

define i1 @icmp_ult_x_y(i8 %x, i8 %y) {
; CHECK-LABEL: @icmp_ult_x_y(
; CHECK-NEXT:    [[AND:%.*]] = and i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[Z:%.*]] = icmp ne i8 [[AND]], [[X]]
; CHECK-NEXT:    ret i1 [[Z]]
;
  %and = and i8 %x, %y
  %z = icmp ult i8 %and, %x
  ret i1 %z
}

define i1 @icmp_ult_x_y_2(i8 %xx, i8 %y) {
; CHECK-LABEL: @icmp_ult_x_y_2(
; CHECK-NEXT:    [[X:%.*]] = mul i8 [[XX:%.*]], [[XX]]
; CHECK-NEXT:    [[AND:%.*]] = and i8 [[X]], [[Y:%.*]]
; CHECK-NEXT:    [[Z:%.*]] = icmp ne i8 [[AND]], [[X]]
; CHECK-NEXT:    ret i1 [[Z]]
;
  %x = mul i8 %xx, %xx
  %and = and i8 %x, %y
  %z = icmp ugt i8 %x, %and
  ret i1 %z
}

define <2 x i1> @icmp_uge_x_y(<2 x i8> %x, <2 x i8> %y) {
; CHECK-LABEL: @icmp_uge_x_y(
; CHECK-NEXT:    [[AND:%.*]] = and <2 x i8> [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[Z:%.*]] = icmp eq <2 x i8> [[AND]], [[X]]
; CHECK-NEXT:    ret <2 x i1> [[Z]]
;
  %and = and <2 x i8> %x, %y
  %z = icmp uge <2 x i8> %and, %x
  ret <2 x i1> %z
}

define i1 @icmp_uge_x_y_2(i8 %xx, i8 %y) {
; CHECK-LABEL: @icmp_uge_x_y_2(
; CHECK-NEXT:    [[X:%.*]] = mul i8 [[XX:%.*]], [[XX]]
; CHECK-NEXT:    [[AND:%.*]] = and i8 [[X]], [[Y:%.*]]
; CHECK-NEXT:    [[Z:%.*]] = icmp eq i8 [[AND]], [[X]]
; CHECK-NEXT:    ret i1 [[Z]]
;
  %x = mul i8 %xx, %xx
  %and = and i8 %x, %y
  %z = icmp ule i8 %x, %and
  ret i1 %z
}

define i1 @icmp_sge_x_negy(i8 %x, i8 %y) {
; CHECK-LABEL: @icmp_sge_x_negy(
; CHECK-NEXT:    [[CY:%.*]] = icmp slt i8 [[Y:%.*]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[CY]])
; CHECK-NEXT:    [[AND:%.*]] = and i8 [[X:%.*]], [[Y]]
; CHECK-NEXT:    [[Z:%.*]] = icmp eq i8 [[AND]], [[X]]
; CHECK-NEXT:    ret i1 [[Z]]
;
  %cy = icmp slt i8 %y, 0
  call void @llvm.assume(i1 %cy)
  %and = and i8 %x, %y
  %z = icmp sge i8 %and, %x
  ret i1 %z
}

define i1 @icmp_slt_x_negy(i8 %x, i8 %y) {
; CHECK-LABEL: @icmp_slt_x_negy(
; CHECK-NEXT:    [[CY:%.*]] = icmp slt i8 [[Y:%.*]], 0
; CHECK-NEXT:    br i1 [[CY]], label [[NEGY:%.*]], label [[POSY:%.*]]
; CHECK:       negy:
; CHECK-NEXT:    [[AND:%.*]] = and i8 [[X:%.*]], [[Y]]
; CHECK-NEXT:    [[Z:%.*]] = icmp ne i8 [[AND]], [[X]]
; CHECK-NEXT:    ret i1 [[Z]]
; CHECK:       posy:
; CHECK-NEXT:    [[R:%.*]] = call i1 @barrier()
; CHECK-NEXT:    ret i1 [[R]]
;
  %cy = icmp slt i8 %y, 0
  br i1 %cy, label %negy, label %posy
negy:
  %and = and i8 %x, %y
  %z = icmp slt i8 %and, %x
  ret i1 %z
posy:
  %r = call i1 @barrier()
  ret i1 %r
}

define i1 @icmp_slt_x_negy_fail_maybe_zero(i8 %x, i8 %y) {
; CHECK-LABEL: @icmp_slt_x_negy_fail_maybe_zero(
; CHECK-NEXT:    [[CY:%.*]] = icmp slt i8 [[Y:%.*]], 1
; CHECK-NEXT:    br i1 [[CY]], label [[NEGY:%.*]], label [[POSY:%.*]]
; CHECK:       negy:
; CHECK-NEXT:    [[AND:%.*]] = and i8 [[X:%.*]], [[Y]]
; CHECK-NEXT:    [[Z:%.*]] = icmp slt i8 [[AND]], [[X]]
; CHECK-NEXT:    ret i1 [[Z]]
; CHECK:       posy:
; CHECK-NEXT:    [[R:%.*]] = call i1 @barrier()
; CHECK-NEXT:    ret i1 [[R]]
;
  %cy = icmp sle i8 %y, 0
  br i1 %cy, label %negy, label %posy
negy:
  %and = and i8 %x, %y
  %z = icmp slt i8 %and, %x
  ret i1 %z
posy:
  %r = call i1 @barrier()
  ret i1 %r
}

define i1 @icmp_sle_x_negy(i8 %x, i8 %yy) {
; CHECK-LABEL: @icmp_sle_x_negy(
; CHECK-NEXT:    ret i1 true
;
  %y = or i8 %yy, 128
  %and = and i8 %y, %x
  %z = icmp sle i8 %and, %x
  ret i1 %z
}

define <2 x i1> @icmp_sgt_x_negy(<2 x i8> %x, <2 x i8> %yy) {
; CHECK-LABEL: @icmp_sgt_x_negy(
; CHECK-NEXT:    ret <2 x i1> zeroinitializer
;
  %y = or <2 x i8> %yy, <i8 128, i8 128>
  %and = and <2 x i8> %y, %x
  %z = icmp sgt <2 x i8> %and, %x
  ret <2 x i1> %z
}

define <2 x i1> @icmp_sgt_x_negy_fail_partial(<2 x i8> %x, <2 x i8> %yy) {
; CHECK-LABEL: @icmp_sgt_x_negy_fail_partial(
; CHECK-NEXT:    [[Y:%.*]] = or <2 x i8> [[YY:%.*]], <i8 -128, i8 4>
; CHECK-NEXT:    [[AND:%.*]] = and <2 x i8> [[Y]], [[X:%.*]]
; CHECK-NEXT:    [[Z:%.*]] = icmp sgt <2 x i8> [[AND]], [[X]]
; CHECK-NEXT:    ret <2 x i1> [[Z]]
;
  %y = or <2 x i8> %yy, <i8 128, i8 4>
  %and = and <2 x i8> %y, %x
  %z = icmp sgt <2 x i8> %and, %x
  ret <2 x i1> %z
}

define <2 x i1> @icmp_sle_x_posy(<2 x i8> %x, <2 x i8> %yy) {
; CHECK-LABEL: @icmp_sle_x_posy(
; CHECK-NEXT:    [[Z:%.*]] = icmp sgt <2 x i8> [[X:%.*]], <i8 -1, i8 -1>
; CHECK-NEXT:    ret <2 x i1> [[Z]]
;
  %y = and <2 x i8> %yy, <i8 127, i8 127>
  %and = and <2 x i8> %y, %x
  %z = icmp sle <2 x i8> %and, %x
  ret <2 x i1> %z
}

define <2 x i1> @icmp_sle_x_posy_fail_partial(<2 x i8> %x, <2 x i8> %yy) {
; CHECK-LABEL: @icmp_sle_x_posy_fail_partial(
; CHECK-NEXT:    [[Y:%.*]] = and <2 x i8> [[YY:%.*]], <i8 127, i8 -65>
; CHECK-NEXT:    [[AND:%.*]] = and <2 x i8> [[Y]], [[X:%.*]]
; CHECK-NEXT:    [[Z:%.*]] = icmp sle <2 x i8> [[AND]], [[X]]
; CHECK-NEXT:    ret <2 x i1> [[Z]]
;
  %y = and <2 x i8> %yy, <i8 127, i8 191>
  %and = and <2 x i8> %y, %x
  %z = icmp sle <2 x i8> %and, %x
  ret <2 x i1> %z
}

define i1 @icmp_sgt_x_posy(i8 %x, i8 %y) {
; CHECK-LABEL: @icmp_sgt_x_posy(
; CHECK-NEXT:    [[CY:%.*]] = icmp sgt i8 [[Y:%.*]], -1
; CHECK-NEXT:    call void @llvm.assume(i1 [[CY]])
; CHECK-NEXT:    [[Z:%.*]] = icmp slt i8 [[X:%.*]], 0
; CHECK-NEXT:    ret i1 [[Z]]
;
  %cy = icmp sge i8 %y, 0
  call void @llvm.assume(i1 %cy)
  %and = and i8 %x, %y
  %z = icmp sgt i8 %and, %x
  ret i1 %z
}

define <2 x i1> @icmp_sgt_negx_y(<2 x i8> %xx, <2 x i8> %y) {
; CHECK-LABEL: @icmp_sgt_negx_y(
; CHECK-NEXT:    [[Z:%.*]] = icmp sgt <2 x i8> [[Y:%.*]], <i8 -1, i8 -1>
; CHECK-NEXT:    ret <2 x i1> [[Z]]
;
  %x = or <2 x i8> %xx, <i8 128, i8 128>
  %and = and <2 x i8> %x, %y
  %z = icmp sgt <2 x i8> %and, %x
  ret <2 x i1> %z
}

define i1 @icmp_sle_negx_y(i8 %x, i8 %y) {
; CHECK-LABEL: @icmp_sle_negx_y(
; CHECK-NEXT:    [[CX:%.*]] = icmp slt i8 [[X:%.*]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[CX]])
; CHECK-NEXT:    [[Z:%.*]] = icmp slt i8 [[Y:%.*]], 0
; CHECK-NEXT:    ret i1 [[Z]]
;
  %cx = icmp slt i8 %x, 0
  call void @llvm.assume(i1 %cx)
  %and = and i8 %x, %y
  %z = icmp sle i8 %and, %x
  ret i1 %z
}

define i1 @icmp_sle_negx_y_fail_maybe_zero(i8 %x, i8 %y) {
; CHECK-LABEL: @icmp_sle_negx_y_fail_maybe_zero(
; CHECK-NEXT:    [[CX:%.*]] = icmp slt i8 [[X:%.*]], 1
; CHECK-NEXT:    call void @llvm.assume(i1 [[CX]])
; CHECK-NEXT:    [[AND:%.*]] = and i8 [[X]], [[Y:%.*]]
; CHECK-NEXT:    [[Z:%.*]] = icmp sle i8 [[AND]], [[X]]
; CHECK-NEXT:    ret i1 [[Z]]
;
  %cx = icmp sle i8 %x, 0
  call void @llvm.assume(i1 %cx)
  %and = and i8 %x, %y
  %z = icmp sle i8 %and, %x
  ret i1 %z
}

define i1 @icmp_eq_x_invertable_y_todo(i8 %x, i1 %y) {
; CHECK-LABEL: @icmp_eq_x_invertable_y_todo(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[Y:%.*]], i8 -8, i8 -25
; CHECK-NEXT:    [[TMP2:%.*]] = and i8 [[TMP1]], [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[TMP2]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %yy = select i1 %y, i8 7, i8 24
  %and = and i8 %x, %yy
  %r = icmp eq i8 %x, %and
  ret i1 %r
}

define i1 @icmp_eq_x_invertable_y(i8 %x, i8 %y) {
; CHECK-LABEL: @icmp_eq_x_invertable_y(
; CHECK-NEXT:    [[TMP1:%.*]] = and i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[TMP1]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %yy = xor i8 %y, -1
  %and = and i8 %x, %yy
  %r = icmp eq i8 %x, %and
  ret i1 %r
}

define i1 @icmp_eq_x_invertable_y_fail_multiuse(i8 %x, i8 %y) {
; CHECK-LABEL: @icmp_eq_x_invertable_y_fail_multiuse(
; CHECK-NEXT:    [[YY:%.*]] = xor i8 [[Y:%.*]], -1
; CHECK-NEXT:    [[AND:%.*]] = and i8 [[YY]], [[X:%.*]]
; CHECK-NEXT:    call void @use.i8(i8 [[AND]])
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[AND]], [[X]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %yy = xor i8 %y, -1
  %and = and i8 %x, %yy
  call void @use.i8(i8 %and)
  %r = icmp eq i8 %x, %and
  ret i1 %r
}

define i1 @icmp_eq_x_invertable_y2_todo(i8 %x, i1 %y) {
; CHECK-LABEL: @icmp_eq_x_invertable_y2_todo(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[Y:%.*]], i8 -8, i8 -25
; CHECK-NEXT:    [[TMP2:%.*]] = or i8 [[TMP1]], [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[TMP2]], -1
; CHECK-NEXT:    ret i1 [[R]]
;
  %yy = select i1 %y, i8 7, i8 24
  %and = and i8 %x, %yy
  %r = icmp eq i8 %yy, %and
  ret i1 %r
}

define i1 @icmp_eq_x_invertable_y2(i8 %x, i8 %y) {
; CHECK-LABEL: @icmp_eq_x_invertable_y2(
; CHECK-NEXT:    [[TMP1:%.*]] = or i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[TMP1]], -1
; CHECK-NEXT:    ret i1 [[R]]
;
  %yy = xor i8 %y, -1
  %and = and i8 %x, %yy
  %r = icmp eq i8 %yy, %and
  ret i1 %r
}

define i1 @icmp_eq_x_invertable_y_fail_immconstant(i8 %x, i8 %y) {
; CHECK-LABEL: @icmp_eq_x_invertable_y_fail_immconstant(
; CHECK-NEXT:    [[AND:%.*]] = and i8 [[X:%.*]], 7
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[AND]], 7
; CHECK-NEXT:    ret i1 [[R]]
;
  %and = and i8 %x, 7
  %r = icmp eq i8 %and, 7
  ret i1 %r
}
