/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake.validator;

import java.math.BigDecimal;
import java.util.Map;
import org.apache.turbine.services.intake.validator.Constraint;
import org.apache.turbine.services.intake.validator.DefaultValidator;
import org.apache.turbine.services.intake.validator.ValidationException;
import org.apache.turbine.util.TurbineException;

public class NumberValidator
extends DefaultValidator {
    private static String INVALID_NUMBER = "Entry was not a valid number";
    private BigDecimal minValue;
    protected String minValueMessage;
    private BigDecimal maxValue;
    protected String maxValueMessage;
    protected String invalidNumberMessage;

    public void init(Map paramMap) throws TurbineException {
        String param;
        super.init(paramMap);
        this.minValueMessage = null;
        this.maxValueMessage = null;
        this.doInit(paramMap);
        Constraint constraint = (Constraint)paramMap.get("notANumberMessage");
        this.invalidNumberMessage = constraint != null ? ((param = constraint.getValue()) != null && param.length() != 0 ? param : (constraint.getMessage().length() != 0 ? constraint.getMessage() : this.getInvalidNumberMessage())) : this.getInvalidNumberMessage();
    }

    protected void doInit(Map paramMap) {
        String param;
        this.minValue = null;
        this.maxValue = null;
        Constraint constraint = (Constraint)paramMap.get("minValue");
        if (constraint != null) {
            param = constraint.getValue();
            this.minValue = new BigDecimal(param);
            this.minValueMessage = constraint.getMessage();
        }
        if ((constraint = (Constraint)paramMap.get("maxValue")) != null) {
            param = constraint.getValue();
            this.maxValue = new BigDecimal(param);
            this.maxValueMessage = constraint.getMessage();
        }
    }

    protected String getInvalidNumberMessage() {
        return INVALID_NUMBER;
    }

    protected void doAssertValidity(String testValue) throws ValidationException {
        BigDecimal bd = null;
        try {
            bd = new BigDecimal(testValue);
        }
        catch (RuntimeException e) {
            this.message = this.invalidNumberMessage;
            throw new ValidationException(this.invalidNumberMessage);
        }
        if (this.minValue != null && bd.compareTo(this.minValue) < 0) {
            this.message = this.minValueMessage;
            throw new ValidationException(this.minValueMessage);
        }
        if (this.maxValue != null && bd.compareTo(this.maxValue) > 0) {
            this.message = this.maxValueMessage;
            throw new ValidationException(this.maxValueMessage);
        }
    }

    public NumberValidator(Map paramMap) throws TurbineException {
        this.init(paramMap);
    }

    public NumberValidator() {
    }
}

