% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_node_voronoi.R
\name{geom_node_voronoi}
\alias{geom_node_voronoi}
\title{Show nodes as voronoi tiles}
\usage{
geom_node_voronoi(
  mapping = NULL,
  data = NULL,
  position = "identity",
  show.legend = NA,
  bound = NULL,
  eps = 1e-09,
  max.radius = NULL,
  normalize = FALSE,
  asp.ratio = 1,
  expand = 0,
  radius = 0,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{ggplot2::aes()}}
or \code{\link[ggplot2:aes_]{ggplot2::aes_()}}. By default x and y are mapped to x and y in
the node data and group set to \code{-1}.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{bound}{The bounding rectangle for the tesselation or a custom polygon
to clip the tesselation to. Defaults to \code{NULL} which creates a rectangle
expanded 10\\% in all directions. If supplied as a bounding box it should be a
vector giving the bounds in the following order: xmin, xmax, ymin, ymax. If
supplied as a polygon it should either be a 2-column matrix or a data.frame
containing an \code{x} and \code{y} column.}

\item{eps}{A value of epsilon used in testing whether a quantity is zero,
mainly in the context of whether points are collinear. If anomalous errors
arise, it is possible that these may averted by adjusting the value of eps
upward or downward.}

\item{max.radius}{The maximum distance a tile can extend from the point of
origin. Will in effect clip each tile to a circle centered at the point with
the given radius. If \code{normalize = TRUE} the radius will be given relative to
the normalized values}

\item{normalize}{Should coordinates be normalized prior to calculations. If
\code{x} and \code{y} are in wildly different ranges it can lead to
tesselation and triangulation that seems off when plotted without
\code{\link[ggplot2:coord_fixed]{ggplot2::coord_fixed()}}. Normalization of coordinates solves this.
The coordinates are transformed back after calculations.}

\item{asp.ratio}{If \code{normalize = TRUE} the x values will be multiplied by this
amount after normalization.}

\item{expand}{A numeric or unit vector of length one, specifying the
expansion amount. Negative values will result in contraction instead. If the
value is given as a numeric it will be understood as a proportion of the
plot area width.}

\item{radius}{As \code{expand} but specifying the corner radius.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}'s \code{params} argument. These
arguments broadly fall into one of 4 categories below. Notably, further
arguments to the \code{position} argument, or aesthetics that are required
can \emph{not} be passed through \code{...}. Unknown arguments that are not part
of the 4 categories below are ignored.
\itemize{
\item Static aesthetics that are not mapped to a scale, but are at a fixed
value and apply to the layer as a whole. For example, \code{colour = "red"}
or \code{linewidth = 3}. The geom's documentation has an \strong{Aesthetics}
section that lists the available options. The 'required' aesthetics
cannot be passed on to the \code{params}. Please note that while passing
unmapped aesthetics as vectors is technically possible, the order and
required length is not guaranteed to be parallel to the input data.
\item When constructing a layer using
a \verb{stat_*()} function, the \code{...} argument can be used to pass on
parameters to the \code{geom} part of the layer. An example of this is
\code{stat_density(geom = "area", outline.type = "both")}. The geom's
documentation lists which parameters it can accept.
\item Inversely, when constructing a layer using a
\verb{geom_*()} function, the \code{...} argument can be used to pass on parameters
to the \code{stat} part of the layer. An example of this is
\code{geom_area(stat = "density", adjust = 0.5)}. The stat's documentation
lists which parameters it can accept.
\item The \code{key_glyph} argument of \code{\link[ggplot2:layer]{layer()}} may also be passed on through
\code{...}. This can be one of the functions described as
\link[ggplot2:draw_key]{key glyphs}, to change the display of the layer in the legend.
}}
}
\description{
This geom is equivalent in functionality to \code{\link[ggforce:geom_delvor]{ggforce::geom_voronoi_tile()}}
and allows for plotting of nodes as tiles from a voronoi tesselation. As with
\code{\link[ggforce:geom_delvor]{ggforce::geom_voronoi_tile()}} it is possible to restrict the size of the
tile to a fixed radius, as well as round corners and expand/contract the
tile.
}
\section{Aesthetics}{

\code{geom_node_voronoi} understand the following aesthetics. Bold aesthetics are
automatically set, but can be overwritten.
\itemize{
\item \strong{x}
\item \strong{y}
\item alpha
\item colour
\item fill
\item shape
\item size
\item stroke
\item filter
}
}

\examples{
require(tidygraph)
gr <- create_notable('meredith') \%>\%
  mutate(group = sample(letters[1:4], n(), TRUE))

ggraph(gr) +
  geom_node_voronoi(aes(fill = group, colour = group), alpha = 0.3) +
  geom_edge_link(alpha = 0.3) +
  geom_node_point()

# Use max.radius to make the tesselation more "node"-like
ggraph(gr) +
  geom_node_voronoi(aes(fill = group, colour = group), alpha = 0.3, max.radius = 1) +
  geom_edge_link(alpha = 0.3) +
  geom_node_point()
}
\seealso{
Other geom_node_*: 
\code{\link{geom_node_arc_bar}()},
\code{\link{geom_node_circle}()},
\code{\link{geom_node_point}()},
\code{\link{geom_node_range}()},
\code{\link{geom_node_sf}()},
\code{\link{geom_node_text}()},
\code{\link{geom_node_tile}()}
}
\author{
Thomas Lin Pedersen
}
\concept{geom_node_*}
