# Area Owners

The below table lists all the `area-`labels used in the **dotnet/aspnetcore** repository and their owners.

| area label                                                                                                                    | Owners                                                                                                                                                                                                                     | Doc Owners  | Description                                                                                                                                                            |
| ----------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| **[area-auth](https://github.com/dotnet/aspnetcore/issues?q=is%3Aissue+is%3Aopen+label%3Aarea-auth)**                         | [@joperezr](https://github.com/joperezr) [@mikekistler](https://github.com/mikekistler) [@halter73](https://github.com/halter73) [@mackinnonbuck](https://github.com/mackinnonbuck)                                        | [@wadepickett](https://github.com/wadepickett) [@tdykstra](https://github.com/tdykstra)  | Authn, Authz, OAuth, OIDC, Bearer                                                                                                                                      |
| **[area-blazor](https://github.com/dotnet/aspnetcore/issues?q=is%3Aissue+is%3Aopen+label%3Aarea-blazor)**                     | [@lewing](https://github.com/lewing) [@danroth27](https://github.com/danroth27) [@aspnet-blazor-eng](https://github.com/aspnet-blazor-eng)                                                                                 | [@guardrex](https://github.com/guardrex)  | Blazor, Razor Components (WASM issues may be moved to dotnet/runtime repo)                                                                                             |
| **[area-commandlinetools](https://github.com/dotnet/aspnetcore/issues?q=is%3Aissue+is%3Aopen+label%3Aarea-commandlinetools)** | [@adityamandaleeka](https://github.com/adityamandaleeka) [@mikekistler](https://github.com/mikekistler) [@captainsafia](https://github.com/captainsafia)                                                                   | [@wadepickett](https://github.com/wadepickett) | Command line tools, dotnet-dev-certs, dotnet-user-jwts, and OpenAPI                                                                                                    |
| **[area-dataprotection](https://github.com/dotnet/aspnetcore/issues?q=is%3Aissue+is%3Aopen+label%3Aarea-dataprotection)**     | [@adityamandaleeka](https://github.com/adityamandaleeka) [@DeagleGross](https://github.com/DeagleGross)                                                                                                                    | [@tdykstra](https://github.com/tdykstra) | DataProtection                                                                                                                                                         |
| **[area-grpc](https://github.com/dotnet/aspnetcore/issues?q=is%3Aissue+is%3Aopen+label%3Aarea-grpc)**                         | [@adityamandaleeka](https://github.com/adityamandaleeka) [@mikekistler](https://github.com/mikekistler) [@jamesnk](https://github.com/jamesnk) [@mgravell](https://github.com/mgravell)                                    | [@wadepickett](https://github.com/wadepickett)  | GRPC wire-up, templates (library itself is  https://github.com/grpc/grpc-dotnet)                                                                                       |
| **[area-healthchecks](https://github.com/dotnet/aspnetcore/issues?q=is%3Aissue+is%3Aopen+label%3Aarea-healthchecks)**         | [@adityamandaleeka](https://github.com/adityamandaleeka) [@samsp-msft](https://github.com/samsp-msft) [@brennanconroy](https://github.com/brennanconroy)                                                                   | [@wadepickett](https://github.com/wadepickett) | Healthchecks (some bugs also in Extensions repo)                                                                                                                       |
| **[area-hosting](https://github.com/dotnet/aspnetcore/issues?q=is%3Aissue+is%3Aopen+label%3Aarea-hosting)**                   | [@joperezr](https://github.com/joperezr) [@danroth27](https://github.com/danroth27) [@halter73](https://github.com/halter73)                                                                                               | [@tdykstra](https://github.com/tdykstra) | Includes Hosting                                                                                                                                                       |
| **[area-identity](https://github.com/dotnet/aspnetcore/issues?q=is%3Aissue+is%3Aopen+label%3Aarea-identity)**                 | [@joperezr](https://github.com/joperezr) [@mikekistler](https://github.com/mikekistler) [@halter73](https://github.com/halter73) [@mackinnonbuck](https://github.com/mackinnonbuck)                                        | [@tdykstra](https://github.com/tdykstra) [@wadepickett](https://github.com/wadepickett) | Identity and providers                                                                                                                                                 |
| **[area-infrastructure](https://github.com/dotnet/aspnetcore/issues?q=is%3Aissue+is%3Aopen+label%3Aarea-infrastructure)**     | [@joperezr](https://github.com/joperezr) [@wtgodbe](https://github.com/wtgodbe)                                                                                                                                            | [@tdykstra](https://github.com/tdykstra) | MSBuild projects/targets, build scripts, CI, Installers and shared framework                                                                                           |
| **[area-middleware](https://github.com/dotnet/aspnetcore/issues?q=is%3Aissue+is%3Aopen+label%3Aarea-middleware)**             | [@adityamandaleeka](https://github.com/adityamandaleeka) [@samsp-msft](https://github.com/samsp-msft) [@brennanconroy](https://github.com/brennanconroy)                                                                   | [@wadepickett](https://github.com/wadepickett) | URL rewrite, redirect, response cache/compression, session, caching, and other general middlewares                                                                     |
| **[area-minimal](https://github.com/dotnet/aspnetcore/issues?q=is%3Aissue+is%3Aopen+label%3Aarea-minimal)**                   | [@adityamandaleeka](https://github.com/adityamandaleeka) [@mikekistler](https://github.com/mikekistler) [@captainsafia](https://github.com/captainsafia) [@mitchdenny](https://github.com/mitchdenny)                      | [@wadepickett](https://github.com/wadepickett)  | Includes minimal APIs, endpoint filters, parameter binding, request delegate generator etc                                                                             |
| **[area-mvc](https://github.com/dotnet/aspnetcore/issues?q=is%3Aissue+is%3Aopen+label%3Aarea-mvc)**                           | [@adityamandaleeka](https://github.com/adityamandaleeka) [@mikekistler](https://github.com/mikekistler) [@captainsafia](https://github.com/captainsafia)                                                                   | [@tdykstra](https://github.com/tdykstra) | MVC, Actions and Controllers, Localization, CORS, most templates                                                                                                       |
| **[area-networking](https://github.com/dotnet/aspnetcore/issues?q=is%3Aissue+is%3Aopen+label%3Aarea-networking)**             | [@adityamandaleeka](https://github.com/adityamandaleeka) [@samsp-msft](https://github.com/samsp-msft) [@brennanconroy](https://github.com/brennanconroy) [@DeagleGross](https://github.com/DeagleGross)                    | [@tdykstra](https://github.com/tdykstra) | Includes Kestrel/servers, protocols such as HTTP/2, HTTP3, YARP, jsonpatch, bedrock, websockets, http client factory, http abstractions, networking aspects of caching |
| **[area-perf](https://github.com/dotnet/aspnetcore/issues?q=is%3Aissue+is%3Aopen+label%3Aarea-perf)**                         | [@joperezr](https://github.com/joperezr) [@sebastienros](https://github.com/sebastienros)                                                                                                                                  | [@tdykstra](https://github.com/tdykstra) | Autofiled performance bugs, perf infra.                                                                                                                                |
| **[area-routing](https://github.com/dotnet/aspnetcore/issues?q=is%3Aissue+is%3Aopen+label%3Aarea-routing)**                   | [@joperezr](https://github.com/joperezr) [@danroth27](https://github.com/danroth27) [@halter73](https://github.com/halter73) [@JamesNK](https://github.com/JamesNK) ([@javiercn](https://github.com/javiercn)  consulting) | [@tdykstra](https://github.com/tdykstra) | Routing                                                                                                                                                                |
| **[area-security](https://github.com/dotnet/aspnetcore/issues?q=is%3Aissue+is%3Aopen+label%3Aarea-security)**                 | [@joperezr](https://github.com/joperezr) [@mikekistler](https://github.com/mikekistler) [@halter73](https://github.com/halter73) [@mackinnonbuck](https://github.com/mackinnonbuck)                                        | [@wadepickett](https://github.com/wadepickett) [@tdykstra](https://github.com/tdykstra)  | security features/work                                                                                                                                                 |
| **[area-signalr](https://github.com/dotnet/aspnetcore/issues?q=is%3Aissue+is%3Aopen+label%3Aarea-signalr)**                   | [@adityamandaleeka](https://github.com/adityamandaleeka) [@mikekistler](https://github.com/mikekistler) [@brennanconroy](https://github.com/brennanconroy)                                                                 | [@wadepickett](https://github.com/wadepickett)  | SignalR clients and servers                                                                                                                                            |
| **[area-ui-rendering](https://github.com/dotnet/aspnetcore/issues?q=is%3Aissue+is%3Aopen+label%3Aarea-ui-rendering)**         | [@joperezr](https://github.com/joperezr) [@danroth27](https://github.com/danroth27) [@mackinnonbuck](https://github.com/mackinnonbuck)                                                                                     | [@wadepickett](https://github.com/wadepickett) | MVC Views/Pages, Razor Views/Page                                                                                                                                      |
| **[area-unified-build](https://github.com/dotnet/aspnetcore/issues?q=is%3Aissue+is%3Aopen+label%3Aarea-unified-build)**       | [@joperezr](https://github.com/joperezr) [@wtgodbe](https://github.com/wtgodbe)                                                                                                                                            | [@tdykstra](https://github.com/tdykstra) | Work related to https://github.com/dotnet/dotnet                                                                                                                       |

| other repo          | Owners                                                                                                                                                   | Doc Owners  | Description                                                                                  |
| ------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------- | -------------------------------------------------------------------------------------------- |
| {aspire}            | [@joperezr](https://github.com/joperezr) [@maddymontaquila](https://github.com/maddymontaquila)                                                          | [@IEvangelist](https://github.com/IEvangelist) | [https://github.com/dotnet/aspire](https://github.com/dotnet/aspire)                         |
| {extensions}        | [@joperezr](https://github.com/joperezr) [@russkie](https://github.com/russkie)                                                                          | [@wadepickett](https://github.com/wadepickett) | [https://github.com/dotnet/extensions](https://github.com/dotnet/extensions)                 |
| {orleans}           | [@adityamandaleeka](https://github.com/adityamandaleeka) [@mikekistler](https://github.com/mikekistler)                                                  | [@IEvangelist](https://github.com/IEvangelist) | [https://github.com/dotnet/orleans](https://github.com/dotnet/orleans)                       |
| {systemwebadapters} | [@joperezr](https://github.com/joperezr) [@danroth27](https://github.com/danroth27)                                                                      | [@tdykstra](https://github.com/tdykstra) | [https://github.com/dotnet/systemweb-adapters](https://github.com/dotnet/systemweb-adapters) |
| {yarp}              | [@adityamandaleeka](https://github.com/adityamandaleeka) [@samsp-msft](https://github.com/samsp-msft) [@benjaminpetit](https://github.com/benjaminpetit) | [@wadepickett](https://github.com/wadepickett) | [https://github.com/dotnet/yarp](https://github.com/dotnet/yarp)                             |

The **dotnet/runtime** repo has [its own list](https://github.com/dotnet/runtime/blob/main/docs/area-owners.md).

## Community Triagers

While not necessarily associated with a specific area, these community members have the power to assist with routing and labeling issues and pull requests, and have been recognized for being consistently knowledgeable about and helpful in this repo:

- [@Andrzej-W](https://github.com/Andrzej-W)
- [@davidacker](https://github.com/davidacker)
- [@egil](https://github.com/egil)
- [@gfoidl](https://github.com/gfoidl)
- [@hishamco](https://github.com/hishamco)
- [@Kahbazi](https://github.com/Kahbazi)
- [@marinasundstrom](https://github.com/marinasundstrom)
- [@martincostello](https://github.com/martincostello)
