/*
 *  SPDX-FileCopyrightText: 2016 Laszlo Fazekas <mneko@freemail.hu>
 *
 *  SPDX-License-Identifier: GPL-2.0-or-later
 */

#include "kis_csv_test.h"


#include <simpletest.h>
#include <QCoreApplication>

#include "filestest.h"

#ifndef FILES_DATA_DIR
#error "FILES_DATA_DIR not set. A directory with the data used for testing the importing of files in krita"
#endif

const QString CsvMimetype = "text/csv";


void KisCsvTest::testFiles()
{
    TestUtil::testFiles(QString(FILES_DATA_DIR) + "/sources", QStringList());
}


void KisCsvTest::testImportFromWriteonly()
{
    TestUtil::testImportFromWriteonly(CsvMimetype);
}


void KisCsvTest::testExportToReadonly()
{
    TestUtil::testExportToReadonly(CsvMimetype);
}


void KisCsvTest::testImportIncorrectFormat()
{
    TestUtil::testImportIncorrectFormat(CsvMimetype);
}

SIMPLE_TEST_MAIN(KisCsvTest)

