# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import msrest.serialization


class Artifact(msrest.serialization.Model):
    """Artifact.

    :ivar id:
    :vartype id: str
    :ivar prefix:
    :vartype prefix: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'prefix': {'key': 'prefix', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword id:
        :paramtype id: str
        :keyword prefix:
        :paramtype prefix: str
        """
        super(Artifact, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.prefix = kwargs.get('prefix', None)


class Asset(msrest.serialization.Model):
    """Asset.

    All required parameters must be populated in order to send to Azure.

    :ivar id:
    :vartype id: str
    :ivar name: Required.
    :vartype name: str
    :ivar type:
    :vartype type: str
    :ivar description:
    :vartype description: str
    :ivar artifacts:
    :vartype artifacts: list[~azure.mgmt.machinelearningservices.models.Artifact]
    :ivar kv_tags: Dictionary of :code:`<string>`.
    :vartype kv_tags: dict[str, str]
    :ivar properties: Dictionary of :code:`<string>`.
    :vartype properties: dict[str, str]
    :ivar runid:
    :vartype runid: str
    :ivar projectid:
    :vartype projectid: str
    :ivar meta: Dictionary of :code:`<string>`.
    :vartype meta: dict[str, str]
    :ivar created_time:
    :vartype created_time: ~datetime.datetime
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'artifacts': {'key': 'artifacts', 'type': '[Artifact]'},
        'kv_tags': {'key': 'kvTags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'runid': {'key': 'runid', 'type': 'str'},
        'projectid': {'key': 'projectid', 'type': 'str'},
        'meta': {'key': 'meta', 'type': '{str}'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword id:
        :paramtype id: str
        :keyword name: Required.
        :paramtype name: str
        :keyword type:
        :paramtype type: str
        :keyword description:
        :paramtype description: str
        :keyword artifacts:
        :paramtype artifacts: list[~azure.mgmt.machinelearningservices.models.Artifact]
        :keyword kv_tags: Dictionary of :code:`<string>`.
        :paramtype kv_tags: dict[str, str]
        :keyword properties: Dictionary of :code:`<string>`.
        :paramtype properties: dict[str, str]
        :keyword runid:
        :paramtype runid: str
        :keyword projectid:
        :paramtype projectid: str
        :keyword meta: Dictionary of :code:`<string>`.
        :paramtype meta: dict[str, str]
        :keyword created_time:
        :paramtype created_time: ~datetime.datetime
        """
        super(Asset, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs['name']
        self.type = kwargs.get('type', None)
        self.description = kwargs.get('description', None)
        self.artifacts = kwargs.get('artifacts', None)
        self.kv_tags = kwargs.get('kv_tags', None)
        self.properties = kwargs.get('properties', None)
        self.runid = kwargs.get('runid', None)
        self.projectid = kwargs.get('projectid', None)
        self.meta = kwargs.get('meta', None)
        self.created_time = kwargs.get('created_time', None)


class AssetDto(msrest.serialization.Model):
    """AssetDto.

    :ivar asset_id:
    :vartype asset_id: str
    :ivar entity_id:
    :vartype entity_id: str
    :ivar data_items: Dictionary of :code:`<DataItem>`.
    :vartype data_items: dict[str, ~azure.mgmt.machinelearningservices.models.DataItem]
    :ivar data_references:
    :vartype data_references: ~azure.mgmt.machinelearningservices.models.DataReferences
    :ivar should_index:
    :vartype should_index: bool
    :ivar dependencies:
    :vartype dependencies: list[~azure.mgmt.machinelearningservices.models.DependentAsset]
    :ivar intellectual_property_publisher_information:
    :vartype intellectual_property_publisher_information:
     ~azure.mgmt.machinelearningservices.models.IntellectualPropertyPublisherInformation
    """

    _attribute_map = {
        'asset_id': {'key': 'assetId', 'type': 'str'},
        'entity_id': {'key': 'entityId', 'type': 'str'},
        'data_items': {'key': 'dataItems', 'type': '{DataItem}'},
        'data_references': {'key': 'dataReferences', 'type': 'DataReferences'},
        'should_index': {'key': 'shouldIndex', 'type': 'bool'},
        'dependencies': {'key': 'dependencies', 'type': '[DependentAsset]'},
        'intellectual_property_publisher_information': {'key': 'intellectualPropertyPublisherInformation', 'type': 'IntellectualPropertyPublisherInformation'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword asset_id:
        :paramtype asset_id: str
        :keyword entity_id:
        :paramtype entity_id: str
        :keyword data_items: Dictionary of :code:`<DataItem>`.
        :paramtype data_items: dict[str, ~azure.mgmt.machinelearningservices.models.DataItem]
        :keyword data_references:
        :paramtype data_references: ~azure.mgmt.machinelearningservices.models.DataReferences
        :keyword should_index:
        :paramtype should_index: bool
        :keyword dependencies:
        :paramtype dependencies: list[~azure.mgmt.machinelearningservices.models.DependentAsset]
        :keyword intellectual_property_publisher_information:
        :paramtype intellectual_property_publisher_information:
         ~azure.mgmt.machinelearningservices.models.IntellectualPropertyPublisherInformation
        """
        super(AssetDto, self).__init__(**kwargs)
        self.asset_id = kwargs.get('asset_id', None)
        self.entity_id = kwargs.get('entity_id', None)
        self.data_items = kwargs.get('data_items', None)
        self.data_references = kwargs.get('data_references', None)
        self.should_index = kwargs.get('should_index', None)
        self.dependencies = kwargs.get('dependencies', None)
        self.intellectual_property_publisher_information = kwargs.get('intellectual_property_publisher_information', None)


class AssetPaginatedResult(msrest.serialization.Model):
    """AssetPaginatedResult.

    :ivar value:
    :vartype value: list[~azure.mgmt.machinelearningservices.models.Asset]
    :ivar continuation_token:
    :vartype continuation_token: str
    :ivar next_link:
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Asset]'},
        'continuation_token': {'key': 'continuationToken', 'type': 'str'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.Asset]
        :keyword continuation_token:
        :paramtype continuation_token: str
        :keyword next_link:
        :paramtype next_link: str
        """
        super(AssetPaginatedResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.continuation_token = kwargs.get('continuation_token', None)
        self.next_link = kwargs.get('next_link', None)


class BatchGetResolvedUrisDto(msrest.serialization.Model):
    """BatchGetResolvedUrisDto.

    :ivar values:
    :vartype values: list[str]
    """

    _attribute_map = {
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword values:
        :paramtype values: list[str]
        """
        super(BatchGetResolvedUrisDto, self).__init__(**kwargs)
        self.values = kwargs.get('values', None)


class BatchModelPathResponseDto(msrest.serialization.Model):
    """BatchModelPathResponseDto.

    :ivar values: Dictionary of :code:`<ModelPathResponseDto>`.
    :vartype values: dict[str, ~azure.mgmt.machinelearningservices.models.ModelPathResponseDto]
    """

    _attribute_map = {
        'values': {'key': 'values', 'type': '{ModelPathResponseDto}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword values: Dictionary of :code:`<ModelPathResponseDto>`.
        :paramtype values: dict[str, ~azure.mgmt.machinelearningservices.models.ModelPathResponseDto]
        """
        super(BatchModelPathResponseDto, self).__init__(**kwargs)
        self.values = kwargs.get('values', None)


class BlobReference(msrest.serialization.Model):
    """BlobReference.

    :ivar blob_uri:
    :vartype blob_uri: str
    :ivar storage_account_arm_id:
    :vartype storage_account_arm_id: str
    """

    _attribute_map = {
        'blob_uri': {'key': 'blobUri', 'type': 'str'},
        'storage_account_arm_id': {'key': 'storageAccountArmId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword blob_uri:
        :paramtype blob_uri: str
        :keyword storage_account_arm_id:
        :paramtype storage_account_arm_id: str
        """
        super(BlobReference, self).__init__(**kwargs)
        self.blob_uri = kwargs.get('blob_uri', None)
        self.storage_account_arm_id = kwargs.get('storage_account_arm_id', None)


class BlobReferenceForConsumptionDto(msrest.serialization.Model):
    """BlobReferenceForConsumptionDto.

    :ivar blob_uri:
    :vartype blob_uri: str
    :ivar storage_account_arm_id:
    :vartype storage_account_arm_id: str
    :ivar credential:
    :vartype credential: ~azure.mgmt.machinelearningservices.models.DataReferenceCredentialDto
    """

    _attribute_map = {
        'blob_uri': {'key': 'blobUri', 'type': 'str'},
        'storage_account_arm_id': {'key': 'storageAccountArmId', 'type': 'str'},
        'credential': {'key': 'credential', 'type': 'DataReferenceCredentialDto'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword blob_uri:
        :paramtype blob_uri: str
        :keyword storage_account_arm_id:
        :paramtype storage_account_arm_id: str
        :keyword credential:
        :paramtype credential: ~azure.mgmt.machinelearningservices.models.DataReferenceCredentialDto
        """
        super(BlobReferenceForConsumptionDto, self).__init__(**kwargs)
        self.blob_uri = kwargs.get('blob_uri', None)
        self.storage_account_arm_id = kwargs.get('storage_account_arm_id', None)
        self.credential = kwargs.get('credential', None)


class ContainerResourceRequirements(msrest.serialization.Model):
    """ContainerResourceRequirements.

    :ivar cpu:
    :vartype cpu: float
    :ivar cpu_limit:
    :vartype cpu_limit: float
    :ivar memory_in_gb:
    :vartype memory_in_gb: float
    :ivar memory_in_gb_limit:
    :vartype memory_in_gb_limit: float
    :ivar gpu_enabled:
    :vartype gpu_enabled: bool
    :ivar gpu:
    :vartype gpu: int
    :ivar fpga:
    :vartype fpga: int
    """

    _attribute_map = {
        'cpu': {'key': 'cpu', 'type': 'float'},
        'cpu_limit': {'key': 'cpuLimit', 'type': 'float'},
        'memory_in_gb': {'key': 'memoryInGB', 'type': 'float'},
        'memory_in_gb_limit': {'key': 'memoryInGBLimit', 'type': 'float'},
        'gpu_enabled': {'key': 'gpuEnabled', 'type': 'bool'},
        'gpu': {'key': 'gpu', 'type': 'int'},
        'fpga': {'key': 'fpga', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword cpu:
        :paramtype cpu: float
        :keyword cpu_limit:
        :paramtype cpu_limit: float
        :keyword memory_in_gb:
        :paramtype memory_in_gb: float
        :keyword memory_in_gb_limit:
        :paramtype memory_in_gb_limit: float
        :keyword gpu_enabled:
        :paramtype gpu_enabled: bool
        :keyword gpu:
        :paramtype gpu: int
        :keyword fpga:
        :paramtype fpga: int
        """
        super(ContainerResourceRequirements, self).__init__(**kwargs)
        self.cpu = kwargs.get('cpu', None)
        self.cpu_limit = kwargs.get('cpu_limit', None)
        self.memory_in_gb = kwargs.get('memory_in_gb', None)
        self.memory_in_gb_limit = kwargs.get('memory_in_gb_limit', None)
        self.gpu_enabled = kwargs.get('gpu_enabled', None)
        self.gpu = kwargs.get('gpu', None)
        self.fpga = kwargs.get('fpga', None)


class CreatedBy(msrest.serialization.Model):
    """CreatedBy.

    :ivar user_object_id:
    :vartype user_object_id: str
    :ivar user_tenant_id:
    :vartype user_tenant_id: str
    :ivar user_name:
    :vartype user_name: str
    """

    _attribute_map = {
        'user_object_id': {'key': 'userObjectId', 'type': 'str'},
        'user_tenant_id': {'key': 'userTenantId', 'type': 'str'},
        'user_name': {'key': 'userName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword user_object_id:
        :paramtype user_object_id: str
        :keyword user_tenant_id:
        :paramtype user_tenant_id: str
        :keyword user_name:
        :paramtype user_name: str
        """
        super(CreatedBy, self).__init__(**kwargs)
        self.user_object_id = kwargs.get('user_object_id', None)
        self.user_tenant_id = kwargs.get('user_tenant_id', None)
        self.user_name = kwargs.get('user_name', None)


class CreateUnregisteredInputModelDto(msrest.serialization.Model):
    """CreateUnregisteredInputModelDto.

    :ivar run_id:
    :vartype run_id: str
    :ivar input_name:
    :vartype input_name: str
    :ivar path:
    :vartype path: str
    :ivar type:
    :vartype type: str
    """

    _attribute_map = {
        'run_id': {'key': 'runId', 'type': 'str'},
        'input_name': {'key': 'inputName', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword run_id:
        :paramtype run_id: str
        :keyword input_name:
        :paramtype input_name: str
        :keyword path:
        :paramtype path: str
        :keyword type:
        :paramtype type: str
        """
        super(CreateUnregisteredInputModelDto, self).__init__(**kwargs)
        self.run_id = kwargs.get('run_id', None)
        self.input_name = kwargs.get('input_name', None)
        self.path = kwargs.get('path', None)
        self.type = kwargs.get('type', None)


class CreateUnregisteredOutputModelDto(msrest.serialization.Model):
    """CreateUnregisteredOutputModelDto.

    :ivar run_id:
    :vartype run_id: str
    :ivar output_name:
    :vartype output_name: str
    :ivar path:
    :vartype path: str
    :ivar type:
    :vartype type: str
    """

    _attribute_map = {
        'run_id': {'key': 'runId', 'type': 'str'},
        'output_name': {'key': 'outputName', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword run_id:
        :paramtype run_id: str
        :keyword output_name:
        :paramtype output_name: str
        :keyword path:
        :paramtype path: str
        :keyword type:
        :paramtype type: str
        """
        super(CreateUnregisteredOutputModelDto, self).__init__(**kwargs)
        self.run_id = kwargs.get('run_id', None)
        self.output_name = kwargs.get('output_name', None)
        self.path = kwargs.get('path', None)
        self.type = kwargs.get('type', None)


class CreationContext(msrest.serialization.Model):
    """CreationContext.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar created_time:
    :vartype created_time: ~datetime.datetime
    :ivar created_by:
    :vartype created_by: ~azure.mgmt.machinelearningservices.models.CreatedBy
    :ivar creation_source:
    :vartype creation_source: str
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'created_by': {'key': 'createdBy', 'type': 'CreatedBy'},
        'creation_source': {'key': 'creationSource', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword created_time:
        :paramtype created_time: ~datetime.datetime
        :keyword created_by:
        :paramtype created_by: ~azure.mgmt.machinelearningservices.models.CreatedBy
        :keyword creation_source:
        :paramtype creation_source: str
        """
        super(CreationContext, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.created_time = kwargs.get('created_time', None)
        self.created_by = kwargs.get('created_by', None)
        self.creation_source = kwargs.get('creation_source', None)


class DataItem(msrest.serialization.Model):
    """DataItem.

    :ivar data: Anything.
    :vartype data: any
    """

    _attribute_map = {
        'data': {'key': 'data', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword data: Anything.
        :paramtype data: any
        """
        super(DataItem, self).__init__(**kwargs)
        self.data = kwargs.get('data', None)


class DataReferenceCredentialDto(msrest.serialization.Model):
    """DataReferenceCredentialDto.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar credential_type:
    :vartype credential_type: str
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'credential_type': {'key': 'credentialType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword credential_type:
        :paramtype credential_type: str
        """
        super(DataReferenceCredentialDto, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.credential_type = kwargs.get('credential_type', None)


class DataReferences(msrest.serialization.Model):
    """DataReferences.

    :ivar blob_references: Dictionary of :code:`<BlobReference>`.
    :vartype blob_references: dict[str, ~azure.mgmt.machinelearningservices.models.BlobReference]
    :ivar image_registry_references: Dictionary of :code:`<ImageReference>`.
    :vartype image_registry_references: dict[str,
     ~azure.mgmt.machinelearningservices.models.ImageReference]
    """

    _attribute_map = {
        'blob_references': {'key': 'blobReferences', 'type': '{BlobReference}'},
        'image_registry_references': {'key': 'imageRegistryReferences', 'type': '{ImageReference}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword blob_references: Dictionary of :code:`<BlobReference>`.
        :paramtype blob_references: dict[str, ~azure.mgmt.machinelearningservices.models.BlobReference]
        :keyword image_registry_references: Dictionary of :code:`<ImageReference>`.
        :paramtype image_registry_references: dict[str,
         ~azure.mgmt.machinelearningservices.models.ImageReference]
        """
        super(DataReferences, self).__init__(**kwargs)
        self.blob_references = kwargs.get('blob_references', None)
        self.image_registry_references = kwargs.get('image_registry_references', None)


class DataReferencesForConsumptionDto(msrest.serialization.Model):
    """DataReferencesForConsumptionDto.

    :ivar blob_references: Dictionary of :code:`<BlobReferenceForConsumptionDto>`.
    :vartype blob_references: dict[str,
     ~azure.mgmt.machinelearningservices.models.BlobReferenceForConsumptionDto]
    :ivar image_registry_references: Dictionary of :code:`<ImageReferenceForConsumptionDto>`.
    :vartype image_registry_references: dict[str,
     ~azure.mgmt.machinelearningservices.models.ImageReferenceForConsumptionDto]
    """

    _attribute_map = {
        'blob_references': {'key': 'blobReferences', 'type': '{BlobReferenceForConsumptionDto}'},
        'image_registry_references': {'key': 'imageRegistryReferences', 'type': '{ImageReferenceForConsumptionDto}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword blob_references: Dictionary of :code:`<BlobReferenceForConsumptionDto>`.
        :paramtype blob_references: dict[str,
         ~azure.mgmt.machinelearningservices.models.BlobReferenceForConsumptionDto]
        :keyword image_registry_references: Dictionary of :code:`<ImageReferenceForConsumptionDto>`.
        :paramtype image_registry_references: dict[str,
         ~azure.mgmt.machinelearningservices.models.ImageReferenceForConsumptionDto]
        """
        super(DataReferencesForConsumptionDto, self).__init__(**kwargs)
        self.blob_references = kwargs.get('blob_references', None)
        self.image_registry_references = kwargs.get('image_registry_references', None)


class DatasetReference(msrest.serialization.Model):
    """DatasetReference.

    :ivar name:
    :vartype name: str
    :ivar id:
    :vartype id: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword id:
        :paramtype id: str
        """
        super(DatasetReference, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.id = kwargs.get('id', None)


class DependencyMapDto(msrest.serialization.Model):
    """DependencyMapDto.

    :ivar dependencies:
    :vartype dependencies: list[~azure.mgmt.machinelearningservices.models.DependencyMapItemDto]
    """

    _attribute_map = {
        'dependencies': {'key': 'dependencies', 'type': '[DependencyMapItemDto]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword dependencies:
        :paramtype dependencies: list[~azure.mgmt.machinelearningservices.models.DependencyMapItemDto]
        """
        super(DependencyMapDto, self).__init__(**kwargs)
        self.dependencies = kwargs.get('dependencies', None)


class DependencyMapItemDto(msrest.serialization.Model):
    """DependencyMapItemDto.

    :ivar source_id:
    :vartype source_id: str
    :ivar destination_id:
    :vartype destination_id: str
    """

    _attribute_map = {
        'source_id': {'key': 'sourceId', 'type': 'str'},
        'destination_id': {'key': 'destinationId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword source_id:
        :paramtype source_id: str
        :keyword destination_id:
        :paramtype destination_id: str
        """
        super(DependencyMapItemDto, self).__init__(**kwargs)
        self.source_id = kwargs.get('source_id', None)
        self.destination_id = kwargs.get('destination_id', None)


class DependentAsset(msrest.serialization.Model):
    """DependentAsset.

    :ivar asset_id:
    :vartype asset_id: str
    """

    _attribute_map = {
        'asset_id': {'key': 'assetId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword asset_id:
        :paramtype asset_id: str
        """
        super(DependentAsset, self).__init__(**kwargs)
        self.asset_id = kwargs.get('asset_id', None)


class DependentEntitiesDto(msrest.serialization.Model):
    """DependentEntitiesDto.

    :ivar asset_id:
    :vartype asset_id: str
    :ivar dependencies:
    :vartype dependencies: list[~azure.mgmt.machinelearningservices.models.DependentAsset]
    """

    _attribute_map = {
        'asset_id': {'key': 'assetId', 'type': 'str'},
        'dependencies': {'key': 'dependencies', 'type': '[DependentAsset]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword asset_id:
        :paramtype asset_id: str
        :keyword dependencies:
        :paramtype dependencies: list[~azure.mgmt.machinelearningservices.models.DependentAsset]
        """
        super(DependentEntitiesDto, self).__init__(**kwargs)
        self.asset_id = kwargs.get('asset_id', None)
        self.dependencies = kwargs.get('dependencies', None)


class ErrorResponse(msrest.serialization.Model):
    """ErrorResponse.

    :ivar code:
    :vartype code: str
    :ivar status_code:
    :vartype status_code: int
    :ivar message:
    :vartype message: str
    :ivar target:
    :vartype target: str
    :ivar details:
    :vartype details: list[~azure.mgmt.machinelearningservices.models.InnerErrorDetails]
    :ivar correlation: Dictionary of :code:`<string>`.
    :vartype correlation: dict[str, str]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'status_code': {'key': 'statusCode', 'type': 'int'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[InnerErrorDetails]'},
        'correlation': {'key': 'correlation', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword code:
        :paramtype code: str
        :keyword status_code:
        :paramtype status_code: int
        :keyword message:
        :paramtype message: str
        :keyword target:
        :paramtype target: str
        :keyword details:
        :paramtype details: list[~azure.mgmt.machinelearningservices.models.InnerErrorDetails]
        :keyword correlation: Dictionary of :code:`<string>`.
        :paramtype correlation: dict[str, str]
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.status_code = kwargs.get('status_code', None)
        self.message = kwargs.get('message', None)
        self.target = kwargs.get('target', None)
        self.details = kwargs.get('details', None)
        self.correlation = kwargs.get('correlation', None)


class ExtensiveModel(msrest.serialization.Model):
    """ExtensiveModel.

    :ivar model:
    :vartype model: ~azure.mgmt.machinelearningservices.models.Model
    :ivar service_list:
    :vartype service_list: list[~azure.mgmt.machinelearningservices.models.ServiceResponseBase]
    :ivar asset_list:
    :vartype asset_list: list[~azure.mgmt.machinelearningservices.models.Asset]
    """

    _attribute_map = {
        'model': {'key': 'Model', 'type': 'Model'},
        'service_list': {'key': 'ServiceList', 'type': '[ServiceResponseBase]'},
        'asset_list': {'key': 'AssetList', 'type': '[Asset]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword model:
        :paramtype model: ~azure.mgmt.machinelearningservices.models.Model
        :keyword service_list:
        :paramtype service_list: list[~azure.mgmt.machinelearningservices.models.ServiceResponseBase]
        :keyword asset_list:
        :paramtype asset_list: list[~azure.mgmt.machinelearningservices.models.Asset]
        """
        super(ExtensiveModel, self).__init__(**kwargs)
        self.model = kwargs.get('model', None)
        self.service_list = kwargs.get('service_list', None)
        self.asset_list = kwargs.get('asset_list', None)


class FeedIndexEntityDto(msrest.serialization.Model):
    """FeedIndexEntityDto.

    :ivar index_entity:
    :vartype index_entity: ~azure.mgmt.machinelearningservices.models.IndexEntity
    :ivar schema_id:
    :vartype schema_id: str
    :ivar entity_schema: Anything.
    :vartype entity_schema: any
    """

    _attribute_map = {
        'index_entity': {'key': 'indexEntity', 'type': 'IndexEntity'},
        'schema_id': {'key': 'schemaId', 'type': 'str'},
        'entity_schema': {'key': 'entitySchema', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword index_entity:
        :paramtype index_entity: ~azure.mgmt.machinelearningservices.models.IndexEntity
        :keyword schema_id:
        :paramtype schema_id: str
        :keyword entity_schema: Anything.
        :paramtype entity_schema: any
        """
        super(FeedIndexEntityDto, self).__init__(**kwargs)
        self.index_entity = kwargs.get('index_entity', None)
        self.schema_id = kwargs.get('schema_id', None)
        self.entity_schema = kwargs.get('entity_schema', None)


class FeedIndexEntityRequestDto(msrest.serialization.Model):
    """FeedIndexEntityRequestDto.

    :ivar feed_entity:
    :vartype feed_entity: ~azure.mgmt.machinelearningservices.models.AssetDto
    :ivar label_to_version_mapping: Dictionary of :code:`<string>`.
    :vartype label_to_version_mapping: dict[str, str]
    """

    _attribute_map = {
        'feed_entity': {'key': 'feedEntity', 'type': 'AssetDto'},
        'label_to_version_mapping': {'key': 'labelToVersionMapping', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword feed_entity:
        :paramtype feed_entity: ~azure.mgmt.machinelearningservices.models.AssetDto
        :keyword label_to_version_mapping: Dictionary of :code:`<string>`.
        :paramtype label_to_version_mapping: dict[str, str]
        """
        super(FeedIndexEntityRequestDto, self).__init__(**kwargs)
        self.feed_entity = kwargs.get('feed_entity', None)
        self.label_to_version_mapping = kwargs.get('label_to_version_mapping', None)


class ImageReference(msrest.serialization.Model):
    """ImageReference.

    :ivar image_registry_reference:
    :vartype image_registry_reference: str
    """

    _attribute_map = {
        'image_registry_reference': {'key': 'imageRegistryReference', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword image_registry_reference:
        :paramtype image_registry_reference: str
        """
        super(ImageReference, self).__init__(**kwargs)
        self.image_registry_reference = kwargs.get('image_registry_reference', None)


class ImageReferenceForConsumptionDto(msrest.serialization.Model):
    """ImageReferenceForConsumptionDto.

    :ivar image_registry_reference:
    :vartype image_registry_reference: str
    :ivar credential:
    :vartype credential: ~azure.mgmt.machinelearningservices.models.DataReferenceCredentialDto
    """

    _attribute_map = {
        'image_registry_reference': {'key': 'imageRegistryReference', 'type': 'str'},
        'credential': {'key': 'credential', 'type': 'DataReferenceCredentialDto'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword image_registry_reference:
        :paramtype image_registry_reference: str
        :keyword credential:
        :paramtype credential: ~azure.mgmt.machinelearningservices.models.DataReferenceCredentialDto
        """
        super(ImageReferenceForConsumptionDto, self).__init__(**kwargs)
        self.image_registry_reference = kwargs.get('image_registry_reference', None)
        self.credential = kwargs.get('credential', None)


class IndexAnnotations(msrest.serialization.Model):
    """IndexAnnotations.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar archived:
    :vartype archived: bool
    :ivar tags: A set of tags. Dictionary of :code:`<string>`.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'archived': {'key': 'archived', 'type': 'bool'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword archived:
        :paramtype archived: bool
        :keyword tags: A set of tags. Dictionary of :code:`<string>`.
        :paramtype tags: dict[str, str]
        """
        super(IndexAnnotations, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.archived = kwargs.get('archived', None)
        self.tags = kwargs.get('tags', None)


class IndexEntity(msrest.serialization.Model):
    """IndexEntity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar schema_id:
    :vartype schema_id: str
    :ivar entity_id:
    :vartype entity_id: str
    :ivar kind: Possible values include: "Invalid", "LineageRoot", "Versioned", "Unversioned".
    :vartype kind: str or ~azure.mgmt.machinelearningservices.models.EntityKind
    :ivar annotations:
    :vartype annotations: ~azure.mgmt.machinelearningservices.models.IndexAnnotations
    :ivar properties:
    :vartype properties: ~azure.mgmt.machinelearningservices.models.IndexProperties
    :ivar internal: Dictionary of :code:`<any>`.
    :vartype internal: dict[str, any]
    :ivar update_sequence:
    :vartype update_sequence: long
    :ivar type:
    :vartype type: str
    :ivar version:
    :vartype version: str
    :ivar entity_container_id:
    :vartype entity_container_id: str
    :ivar entity_object_id:
    :vartype entity_object_id: str
    :ivar resource_type:
    :vartype resource_type: str
    :ivar relationships:
    :vartype relationships: list[~azure.mgmt.machinelearningservices.models.Relationship]
    :ivar asset_id:
    :vartype asset_id: str
    """

    _validation = {
        'version': {'readonly': True},
        'entity_container_id': {'readonly': True},
        'entity_object_id': {'readonly': True},
        'resource_type': {'readonly': True},
    }

    _attribute_map = {
        'schema_id': {'key': 'schemaId', 'type': 'str'},
        'entity_id': {'key': 'entityId', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'annotations': {'key': 'annotations', 'type': 'IndexAnnotations'},
        'properties': {'key': 'properties', 'type': 'IndexProperties'},
        'internal': {'key': 'internal', 'type': '{object}'},
        'update_sequence': {'key': 'updateSequence', 'type': 'long'},
        'type': {'key': 'type', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'entity_container_id': {'key': 'entityContainerId', 'type': 'str'},
        'entity_object_id': {'key': 'entityObjectId', 'type': 'str'},
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'relationships': {'key': 'relationships', 'type': '[Relationship]'},
        'asset_id': {'key': 'assetId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword schema_id:
        :paramtype schema_id: str
        :keyword entity_id:
        :paramtype entity_id: str
        :keyword kind: Possible values include: "Invalid", "LineageRoot", "Versioned", "Unversioned".
        :paramtype kind: str or ~azure.mgmt.machinelearningservices.models.EntityKind
        :keyword annotations:
        :paramtype annotations: ~azure.mgmt.machinelearningservices.models.IndexAnnotations
        :keyword properties:
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.IndexProperties
        :keyword internal: Dictionary of :code:`<any>`.
        :paramtype internal: dict[str, any]
        :keyword update_sequence:
        :paramtype update_sequence: long
        :keyword type:
        :paramtype type: str
        :keyword relationships:
        :paramtype relationships: list[~azure.mgmt.machinelearningservices.models.Relationship]
        :keyword asset_id:
        :paramtype asset_id: str
        """
        super(IndexEntity, self).__init__(**kwargs)
        self.schema_id = kwargs.get('schema_id', None)
        self.entity_id = kwargs.get('entity_id', None)
        self.kind = kwargs.get('kind', None)
        self.annotations = kwargs.get('annotations', None)
        self.properties = kwargs.get('properties', None)
        self.internal = kwargs.get('internal', None)
        self.update_sequence = kwargs.get('update_sequence', None)
        self.type = kwargs.get('type', None)
        self.version = None
        self.entity_container_id = None
        self.entity_object_id = None
        self.resource_type = None
        self.relationships = kwargs.get('relationships', None)
        self.asset_id = kwargs.get('asset_id', None)


class IndexProperties(msrest.serialization.Model):
    """IndexProperties.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar creation_context:
    :vartype creation_context: ~azure.mgmt.machinelearningservices.models.CreationContext
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'creation_context': {'key': 'creationContext', 'type': 'CreationContext'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword creation_context:
        :paramtype creation_context: ~azure.mgmt.machinelearningservices.models.CreationContext
        """
        super(IndexProperties, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.creation_context = kwargs.get('creation_context', None)


class InnerErrorDetails(msrest.serialization.Model):
    """InnerErrorDetails.

    :ivar code:
    :vartype code: str
    :ivar message:
    :vartype message: str
    :ivar target:
    :vartype target: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword code:
        :paramtype code: str
        :keyword message:
        :paramtype message: str
        :keyword target:
        :paramtype target: str
        """
        super(InnerErrorDetails, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.target = kwargs.get('target', None)


class IntellectualPropertyPublisherInformation(msrest.serialization.Model):
    """IntellectualPropertyPublisherInformation.

    :ivar intellectual_property_publisher:
    :vartype intellectual_property_publisher: str
    """

    _attribute_map = {
        'intellectual_property_publisher': {'key': 'intellectualPropertyPublisher', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword intellectual_property_publisher:
        :paramtype intellectual_property_publisher: str
        """
        super(IntellectualPropertyPublisherInformation, self).__init__(**kwargs)
        self.intellectual_property_publisher = kwargs.get('intellectual_property_publisher', None)


class ListModelsRequest(msrest.serialization.Model):
    """ListModelsRequest.

    :ivar name:
    :vartype name: str
    :ivar tag:
    :vartype tag: str
    :ivar version:
    :vartype version: str
    :ivar framework:
    :vartype framework: str
    :ivar description:
    :vartype description: str
    :ivar count:
    :vartype count: int
    :ivar offset:
    :vartype offset: int
    :ivar skip_token:
    :vartype skip_token: str
    :ivar tags: A set of tags.
    :vartype tags: str
    :ivar properties:
    :vartype properties: str
    :ivar run_id:
    :vartype run_id: str
    :ivar dataset_id:
    :vartype dataset_id: str
    :ivar order_by: Possible values include: "CreatedAtDesc", "CreatedAtAsc", "UpdatedAtDesc",
     "UpdatedAtAsc".
    :vartype order_by: str or ~azure.mgmt.machinelearningservices.models.OrderString
    :ivar latest_version_only:
    :vartype latest_version_only: bool
    :ivar modified_after:
    :vartype modified_after: ~datetime.datetime
    :ivar modified_before:
    :vartype modified_before: ~datetime.datetime
    :ivar list_view_type: Possible values include: "ActiveOnly", "ArchivedOnly", "All".
    :vartype list_view_type: str or ~azure.mgmt.machinelearningservices.models.ListViewType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tag': {'key': 'tag', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'framework': {'key': 'framework', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'count': {'key': 'count', 'type': 'int'},
        'offset': {'key': 'offset', 'type': 'int'},
        'skip_token': {'key': 'skipToken', 'type': 'str'},
        'tags': {'key': 'tags', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'str'},
        'run_id': {'key': 'runId', 'type': 'str'},
        'dataset_id': {'key': 'datasetId', 'type': 'str'},
        'order_by': {'key': 'orderBy', 'type': 'str'},
        'latest_version_only': {'key': 'latestVersionOnly', 'type': 'bool'},
        'modified_after': {'key': 'modifiedAfter', 'type': 'iso-8601'},
        'modified_before': {'key': 'modifiedBefore', 'type': 'iso-8601'},
        'list_view_type': {'key': 'listViewType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword tag:
        :paramtype tag: str
        :keyword version:
        :paramtype version: str
        :keyword framework:
        :paramtype framework: str
        :keyword description:
        :paramtype description: str
        :keyword count:
        :paramtype count: int
        :keyword offset:
        :paramtype offset: int
        :keyword skip_token:
        :paramtype skip_token: str
        :keyword tags: A set of tags.
        :paramtype tags: str
        :keyword properties:
        :paramtype properties: str
        :keyword run_id:
        :paramtype run_id: str
        :keyword dataset_id:
        :paramtype dataset_id: str
        :keyword order_by: Possible values include: "CreatedAtDesc", "CreatedAtAsc", "UpdatedAtDesc",
         "UpdatedAtAsc".
        :paramtype order_by: str or ~azure.mgmt.machinelearningservices.models.OrderString
        :keyword latest_version_only:
        :paramtype latest_version_only: bool
        :keyword modified_after:
        :paramtype modified_after: ~datetime.datetime
        :keyword modified_before:
        :paramtype modified_before: ~datetime.datetime
        :keyword list_view_type: Possible values include: "ActiveOnly", "ArchivedOnly", "All".
        :paramtype list_view_type: str or ~azure.mgmt.machinelearningservices.models.ListViewType
        """
        super(ListModelsRequest, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.tag = kwargs.get('tag', None)
        self.version = kwargs.get('version', None)
        self.framework = kwargs.get('framework', None)
        self.description = kwargs.get('description', None)
        self.count = kwargs.get('count', None)
        self.offset = kwargs.get('offset', None)
        self.skip_token = kwargs.get('skip_token', None)
        self.tags = kwargs.get('tags', None)
        self.properties = kwargs.get('properties', None)
        self.run_id = kwargs.get('run_id', None)
        self.dataset_id = kwargs.get('dataset_id', None)
        self.order_by = kwargs.get('order_by', None)
        self.latest_version_only = kwargs.get('latest_version_only', None)
        self.modified_after = kwargs.get('modified_after', None)
        self.modified_before = kwargs.get('modified_before', None)
        self.list_view_type = kwargs.get('list_view_type', None)


class Model(msrest.serialization.Model):
    """Model.

    All required parameters must be populated in order to send to Azure.

    :ivar id:
    :vartype id: str
    :ivar name: Required.
    :vartype name: str
    :ivar framework:
    :vartype framework: str
    :ivar framework_version:
    :vartype framework_version: str
    :ivar version:
    :vartype version: long
    :ivar tags: A set of tags.
    :vartype tags: list[str]
    :ivar datasets:
    :vartype datasets: list[~azure.mgmt.machinelearningservices.models.DatasetReference]
    :ivar url:
    :vartype url: str
    :ivar mime_type: Required.
    :vartype mime_type: str
    :ivar description:
    :vartype description: str
    :ivar created_time:
    :vartype created_time: ~datetime.datetime
    :ivar modified_time:
    :vartype modified_time: ~datetime.datetime
    :ivar unpack:
    :vartype unpack: bool
    :ivar parent_model_id:
    :vartype parent_model_id: str
    :ivar run_id:
    :vartype run_id: str
    :ivar experiment_name:
    :vartype experiment_name: str
    :ivar kv_tags: Dictionary of :code:`<string>`.
    :vartype kv_tags: dict[str, str]
    :ivar properties: Dictionary of :code:`<string>`.
    :vartype properties: dict[str, str]
    :ivar derived_model_ids:
    :vartype derived_model_ids: list[str]
    :ivar inputs_schema:
    :vartype inputs_schema: list[~azure.mgmt.machinelearningservices.models.ModelSchema]
    :ivar outputs_schema:
    :vartype outputs_schema: list[~azure.mgmt.machinelearningservices.models.ModelSchema]
    :ivar sample_input_data:
    :vartype sample_input_data: str
    :ivar sample_output_data:
    :vartype sample_output_data: str
    :ivar resource_requirements:
    :vartype resource_requirements:
     ~azure.mgmt.machinelearningservices.models.ContainerResourceRequirements
    :ivar created_by:
    :vartype created_by: ~azure.mgmt.machinelearningservices.models.User
    :ivar modified_by:
    :vartype modified_by: ~azure.mgmt.machinelearningservices.models.User
    :ivar flavors: Dictionary of
     <components·8urbg9·schemas·model·properties·flavors·additionalproperties>.
    :vartype flavors: dict[str, dict[str, str]]
    :ivar model_format: Possible values include: "CUSTOM", "MLFLOW", "TRITON", "PRESETS".
    :vartype model_format: str or ~azure.mgmt.machinelearningservices.models.ModelFormatEnum
    :ivar stage:
    :vartype stage: str
    :ivar model_container_id:
    :vartype model_container_id: str
    :ivar mms_id:
    :vartype mms_id: str
    :ivar default_deployment_settings:
    :vartype default_deployment_settings:
     ~azure.mgmt.machinelearningservices.models.ModelDeploymentSettings
    :ivar is_anonymous:
    :vartype is_anonymous: bool
    :ivar is_archived:
    :vartype is_archived: bool
    :ivar is_registered:
    :vartype is_registered: bool
    :ivar data_path:
    :vartype data_path: str
    :ivar model_type:
    :vartype model_type: str
    :ivar asset_id:
    :vartype asset_id: str
    """

    _validation = {
        'name': {'required': True},
        'mime_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'framework': {'key': 'framework', 'type': 'str'},
        'framework_version': {'key': 'frameworkVersion', 'type': 'str'},
        'version': {'key': 'version', 'type': 'long'},
        'tags': {'key': 'tags', 'type': '[str]'},
        'datasets': {'key': 'datasets', 'type': '[DatasetReference]'},
        'url': {'key': 'url', 'type': 'str'},
        'mime_type': {'key': 'mimeType', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'modified_time': {'key': 'modifiedTime', 'type': 'iso-8601'},
        'unpack': {'key': 'unpack', 'type': 'bool'},
        'parent_model_id': {'key': 'parentModelId', 'type': 'str'},
        'run_id': {'key': 'runId', 'type': 'str'},
        'experiment_name': {'key': 'experimentName', 'type': 'str'},
        'kv_tags': {'key': 'kvTags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'derived_model_ids': {'key': 'derivedModelIds', 'type': '[str]'},
        'inputs_schema': {'key': 'inputsSchema', 'type': '[ModelSchema]'},
        'outputs_schema': {'key': 'outputsSchema', 'type': '[ModelSchema]'},
        'sample_input_data': {'key': 'sampleInputData', 'type': 'str'},
        'sample_output_data': {'key': 'sampleOutputData', 'type': 'str'},
        'resource_requirements': {'key': 'resourceRequirements', 'type': 'ContainerResourceRequirements'},
        'created_by': {'key': 'createdBy', 'type': 'User'},
        'modified_by': {'key': 'modifiedBy', 'type': 'User'},
        'flavors': {'key': 'flavors', 'type': '{{str}}'},
        'model_format': {'key': 'modelFormat', 'type': 'str'},
        'stage': {'key': 'stage', 'type': 'str'},
        'model_container_id': {'key': 'modelContainerId', 'type': 'str'},
        'mms_id': {'key': 'mmsId', 'type': 'str'},
        'default_deployment_settings': {'key': 'defaultDeploymentSettings', 'type': 'ModelDeploymentSettings'},
        'is_anonymous': {'key': 'isAnonymous', 'type': 'bool'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'is_registered': {'key': 'isRegistered', 'type': 'bool'},
        'data_path': {'key': 'dataPath', 'type': 'str'},
        'model_type': {'key': 'modelType', 'type': 'str'},
        'asset_id': {'key': 'assetId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword id:
        :paramtype id: str
        :keyword name: Required.
        :paramtype name: str
        :keyword framework:
        :paramtype framework: str
        :keyword framework_version:
        :paramtype framework_version: str
        :keyword version:
        :paramtype version: long
        :keyword tags: A set of tags.
        :paramtype tags: list[str]
        :keyword datasets:
        :paramtype datasets: list[~azure.mgmt.machinelearningservices.models.DatasetReference]
        :keyword url:
        :paramtype url: str
        :keyword mime_type: Required.
        :paramtype mime_type: str
        :keyword description:
        :paramtype description: str
        :keyword created_time:
        :paramtype created_time: ~datetime.datetime
        :keyword modified_time:
        :paramtype modified_time: ~datetime.datetime
        :keyword unpack:
        :paramtype unpack: bool
        :keyword parent_model_id:
        :paramtype parent_model_id: str
        :keyword run_id:
        :paramtype run_id: str
        :keyword experiment_name:
        :paramtype experiment_name: str
        :keyword kv_tags: Dictionary of :code:`<string>`.
        :paramtype kv_tags: dict[str, str]
        :keyword properties: Dictionary of :code:`<string>`.
        :paramtype properties: dict[str, str]
        :keyword derived_model_ids:
        :paramtype derived_model_ids: list[str]
        :keyword inputs_schema:
        :paramtype inputs_schema: list[~azure.mgmt.machinelearningservices.models.ModelSchema]
        :keyword outputs_schema:
        :paramtype outputs_schema: list[~azure.mgmt.machinelearningservices.models.ModelSchema]
        :keyword sample_input_data:
        :paramtype sample_input_data: str
        :keyword sample_output_data:
        :paramtype sample_output_data: str
        :keyword resource_requirements:
        :paramtype resource_requirements:
         ~azure.mgmt.machinelearningservices.models.ContainerResourceRequirements
        :keyword created_by:
        :paramtype created_by: ~azure.mgmt.machinelearningservices.models.User
        :keyword modified_by:
        :paramtype modified_by: ~azure.mgmt.machinelearningservices.models.User
        :keyword flavors: Dictionary of
         <components·8urbg9·schemas·model·properties·flavors·additionalproperties>.
        :paramtype flavors: dict[str, dict[str, str]]
        :keyword model_format: Possible values include: "CUSTOM", "MLFLOW", "TRITON", "PRESETS".
        :paramtype model_format: str or ~azure.mgmt.machinelearningservices.models.ModelFormatEnum
        :keyword stage:
        :paramtype stage: str
        :keyword model_container_id:
        :paramtype model_container_id: str
        :keyword mms_id:
        :paramtype mms_id: str
        :keyword default_deployment_settings:
        :paramtype default_deployment_settings:
         ~azure.mgmt.machinelearningservices.models.ModelDeploymentSettings
        :keyword is_anonymous:
        :paramtype is_anonymous: bool
        :keyword is_archived:
        :paramtype is_archived: bool
        :keyword is_registered:
        :paramtype is_registered: bool
        :keyword data_path:
        :paramtype data_path: str
        :keyword model_type:
        :paramtype model_type: str
        :keyword asset_id:
        :paramtype asset_id: str
        """
        super(Model, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs['name']
        self.framework = kwargs.get('framework', None)
        self.framework_version = kwargs.get('framework_version', None)
        self.version = kwargs.get('version', None)
        self.tags = kwargs.get('tags', None)
        self.datasets = kwargs.get('datasets', None)
        self.url = kwargs.get('url', None)
        self.mime_type = kwargs['mime_type']
        self.description = kwargs.get('description', None)
        self.created_time = kwargs.get('created_time', None)
        self.modified_time = kwargs.get('modified_time', None)
        self.unpack = kwargs.get('unpack', None)
        self.parent_model_id = kwargs.get('parent_model_id', None)
        self.run_id = kwargs.get('run_id', None)
        self.experiment_name = kwargs.get('experiment_name', None)
        self.kv_tags = kwargs.get('kv_tags', None)
        self.properties = kwargs.get('properties', None)
        self.derived_model_ids = kwargs.get('derived_model_ids', None)
        self.inputs_schema = kwargs.get('inputs_schema', None)
        self.outputs_schema = kwargs.get('outputs_schema', None)
        self.sample_input_data = kwargs.get('sample_input_data', None)
        self.sample_output_data = kwargs.get('sample_output_data', None)
        self.resource_requirements = kwargs.get('resource_requirements', None)
        self.created_by = kwargs.get('created_by', None)
        self.modified_by = kwargs.get('modified_by', None)
        self.flavors = kwargs.get('flavors', None)
        self.model_format = kwargs.get('model_format', None)
        self.stage = kwargs.get('stage', None)
        self.model_container_id = kwargs.get('model_container_id', None)
        self.mms_id = kwargs.get('mms_id', None)
        self.default_deployment_settings = kwargs.get('default_deployment_settings', None)
        self.is_anonymous = kwargs.get('is_anonymous', None)
        self.is_archived = kwargs.get('is_archived', None)
        self.is_registered = kwargs.get('is_registered', None)
        self.data_path = kwargs.get('data_path', None)
        self.model_type = kwargs.get('model_type', None)
        self.asset_id = kwargs.get('asset_id', None)


class ModelBatchDto(msrest.serialization.Model):
    """ModelBatchDto.

    :ivar model_ids:
    :vartype model_ids: list[str]
    """

    _attribute_map = {
        'model_ids': {'key': 'modelIds', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword model_ids:
        :paramtype model_ids: list[str]
        """
        super(ModelBatchDto, self).__init__(**kwargs)
        self.model_ids = kwargs.get('model_ids', None)


class ModelBatchResponseDto(msrest.serialization.Model):
    """ModelBatchResponseDto.

    :ivar models: Dictionary of :code:`<Model>`.
    :vartype models: dict[str, ~azure.mgmt.machinelearningservices.models.Model]
    """

    _attribute_map = {
        'models': {'key': 'models', 'type': '{Model}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword models: Dictionary of :code:`<Model>`.
        :paramtype models: dict[str, ~azure.mgmt.machinelearningservices.models.Model]
        """
        super(ModelBatchResponseDto, self).__init__(**kwargs)
        self.models = kwargs.get('models', None)


class ModelContainerRequest(msrest.serialization.Model):
    """ModelContainerRequest.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required.
    :vartype name: str
    :ivar description:
    :vartype description: str
    :ivar kv_tags: Dictionary of :code:`<string>`.
    :vartype kv_tags: dict[str, str]
    :ivar is_archived:
    :vartype is_archived: bool
    :ivar is_registered:
    :vartype is_registered: bool
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'kv_tags': {'key': 'kvTags', 'type': '{str}'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'is_registered': {'key': 'isRegistered', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required.
        :paramtype name: str
        :keyword description:
        :paramtype description: str
        :keyword kv_tags: Dictionary of :code:`<string>`.
        :paramtype kv_tags: dict[str, str]
        :keyword is_archived:
        :paramtype is_archived: bool
        :keyword is_registered:
        :paramtype is_registered: bool
        """
        super(ModelContainerRequest, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.description = kwargs.get('description', None)
        self.kv_tags = kwargs.get('kv_tags', None)
        self.is_archived = kwargs.get('is_archived', None)
        self.is_registered = kwargs.get('is_registered', None)


class ModelDeploymentSettings(msrest.serialization.Model):
    """ModelDeploymentSettings.

    All required parameters must be populated in order to send to Azure.

    :ivar model_format: Required. Possible values include: "CUSTOM", "MLFLOW", "TRITON", "PRESETS".
    :vartype model_format: str or ~azure.mgmt.machinelearningservices.models.ModelFormatEnum
    :ivar model_name:
    :vartype model_name: str
    :ivar model_version:
    :vartype model_version: str
    :ivar model_type:
    :vartype model_type: str
    """

    _validation = {
        'model_format': {'required': True},
    }

    _attribute_map = {
        'model_format': {'key': 'modelFormat', 'type': 'str'},
        'model_name': {'key': 'ModelName', 'type': 'str'},
        'model_version': {'key': 'ModelVersion', 'type': 'str'},
        'model_type': {'key': 'ModelType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword model_format: Required. Possible values include: "CUSTOM", "MLFLOW", "TRITON",
         "PRESETS".
        :paramtype model_format: str or ~azure.mgmt.machinelearningservices.models.ModelFormatEnum
        :keyword model_name:
        :paramtype model_name: str
        :keyword model_version:
        :paramtype model_version: str
        :keyword model_type:
        :paramtype model_type: str
        """
        super(ModelDeploymentSettings, self).__init__(**kwargs)
        self.model_format = kwargs['model_format']
        self.model_name = kwargs.get('model_name', None)
        self.model_version = kwargs.get('model_version', None)
        self.model_type = kwargs.get('model_type', None)


class ModelListModelsRequestPagedResponse(msrest.serialization.Model):
    """ModelListModelsRequestPagedResponse.

    :ivar value:
    :vartype value: list[~azure.mgmt.machinelearningservices.models.Model]
    :ivar next_link:
    :vartype next_link: str
    :ivar continuation_token:
    :vartype continuation_token: str
    :ivar next_request:
    :vartype next_request: ~azure.mgmt.machinelearningservices.models.ListModelsRequest
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Model]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'continuation_token': {'key': 'continuationToken', 'type': 'str'},
        'next_request': {'key': 'nextRequest', 'type': 'ListModelsRequest'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.Model]
        :keyword next_link:
        :paramtype next_link: str
        :keyword continuation_token:
        :paramtype continuation_token: str
        :keyword next_request:
        :paramtype next_request: ~azure.mgmt.machinelearningservices.models.ListModelsRequest
        """
        super(ModelListModelsRequestPagedResponse, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)
        self.continuation_token = kwargs.get('continuation_token', None)
        self.next_request = kwargs.get('next_request', None)


class ModelPagedResponse(msrest.serialization.Model):
    """ModelPagedResponse.

    :ivar value:
    :vartype value: list[~azure.mgmt.machinelearningservices.models.Model]
    :ivar continuation_token:
    :vartype continuation_token: str
    :ivar next_link:
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Model]'},
        'continuation_token': {'key': 'continuationToken', 'type': 'str'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.Model]
        :keyword continuation_token:
        :paramtype continuation_token: str
        :keyword next_link:
        :paramtype next_link: str
        """
        super(ModelPagedResponse, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.continuation_token = kwargs.get('continuation_token', None)
        self.next_link = kwargs.get('next_link', None)


class ModelPathResponseDto(msrest.serialization.Model):
    """ModelPathResponseDto.

    :ivar path:
    :vartype path: str
    :ivar type:
    :vartype type: str
    """

    _attribute_map = {
        'path': {'key': 'path', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword path:
        :paramtype path: str
        :keyword type:
        :paramtype type: str
        """
        super(ModelPathResponseDto, self).__init__(**kwargs)
        self.path = kwargs.get('path', None)
        self.type = kwargs.get('type', None)


class ModelSchema(msrest.serialization.Model):
    """ModelSchema.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required.
    :vartype name: str
    :ivar data_type: Possible values include: "undefined", "bool", "uint8", "uint16", "uint32",
     "uint64", "int8", "int16", "int32", "int64", "float16", "float32", "float64", "bfloat16",
     "complex64", "complex128", "string".
    :vartype data_type: str or ~azure.mgmt.machinelearningservices.models.ModelSchemaDataType
    :ivar shape:
    :vartype shape: list[int]
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'data_type': {'key': 'dataType', 'type': 'str'},
        'shape': {'key': 'shape', 'type': '[int]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required.
        :paramtype name: str
        :keyword data_type: Possible values include: "undefined", "bool", "uint8", "uint16", "uint32",
         "uint64", "int8", "int16", "int32", "int64", "float16", "float32", "float64", "bfloat16",
         "complex64", "complex128", "string".
        :paramtype data_type: str or ~azure.mgmt.machinelearningservices.models.ModelSchemaDataType
        :keyword shape:
        :paramtype shape: list[int]
        """
        super(ModelSchema, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.data_type = kwargs.get('data_type', None)
        self.shape = kwargs.get('shape', None)


class ModelSettingsIdentifiers(msrest.serialization.Model):
    """ModelSettingsIdentifiers.

    :ivar model_id:
    :vartype model_id: str
    :ivar engine_id:
    :vartype engine_id: str
    """

    _attribute_map = {
        'model_id': {'key': 'modelId', 'type': 'str'},
        'engine_id': {'key': 'engineId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword model_id:
        :paramtype model_id: str
        :keyword engine_id:
        :paramtype engine_id: str
        """
        super(ModelSettingsIdentifiers, self).__init__(**kwargs)
        self.model_id = kwargs.get('model_id', None)
        self.engine_id = kwargs.get('engine_id', None)


class Operation(msrest.serialization.Model):
    """Operation.

    :ivar value: Anything.
    :vartype value: any
    :ivar path:
    :vartype path: str
    :ivar op:
    :vartype op: str
    :ivar from_property:
    :vartype from_property: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'object'},
        'path': {'key': 'path', 'type': 'str'},
        'op': {'key': 'op', 'type': 'str'},
        'from_property': {'key': 'from', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword value: Anything.
        :paramtype value: any
        :keyword path:
        :paramtype path: str
        :keyword op:
        :paramtype op: str
        :keyword from_property:
        :paramtype from_property: str
        """
        super(Operation, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.path = kwargs.get('path', None)
        self.op = kwargs.get('op', None)
        self.from_property = kwargs.get('from_property', None)


class ProviderFeedEntityRequestDto(msrest.serialization.Model):
    """ProviderFeedEntityRequestDto.

    :ivar source_and_target_asset_ids:
    :vartype source_and_target_asset_ids:
     ~azure.mgmt.machinelearningservices.models.DependencyMapItemDto
    :ivar dependency_map_dto:
    :vartype dependency_map_dto: ~azure.mgmt.machinelearningservices.models.DependencyMapDto
    :ivar label_to_version_mapping: Dictionary of :code:`<string>`.
    :vartype label_to_version_mapping: dict[str, str]
    """

    _attribute_map = {
        'source_and_target_asset_ids': {'key': 'sourceAndTargetAssetIds', 'type': 'DependencyMapItemDto'},
        'dependency_map_dto': {'key': 'dependencyMapDto', 'type': 'DependencyMapDto'},
        'label_to_version_mapping': {'key': 'labelToVersionMapping', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword source_and_target_asset_ids:
        :paramtype source_and_target_asset_ids:
         ~azure.mgmt.machinelearningservices.models.DependencyMapItemDto
        :keyword dependency_map_dto:
        :paramtype dependency_map_dto: ~azure.mgmt.machinelearningservices.models.DependencyMapDto
        :keyword label_to_version_mapping: Dictionary of :code:`<string>`.
        :paramtype label_to_version_mapping: dict[str, str]
        """
        super(ProviderFeedEntityRequestDto, self).__init__(**kwargs)
        self.source_and_target_asset_ids = kwargs.get('source_and_target_asset_ids', None)
        self.dependency_map_dto = kwargs.get('dependency_map_dto', None)
        self.label_to_version_mapping = kwargs.get('label_to_version_mapping', None)


class Relationship(msrest.serialization.Model):
    """Relationship.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar relation_type:
    :vartype relation_type: str
    :ivar target_entity_id:
    :vartype target_entity_id: str
    :ivar asset_id:
    :vartype asset_id: str
    :ivar entity_type:
    :vartype entity_type: str
    :ivar direction:
    :vartype direction: str
    :ivar entity_container_id:
    :vartype entity_container_id: str
    """

    _validation = {
        'entity_type': {'readonly': True},
        'entity_container_id': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'relation_type': {'key': 'relationType', 'type': 'str'},
        'target_entity_id': {'key': 'targetEntityId', 'type': 'str'},
        'asset_id': {'key': 'assetId', 'type': 'str'},
        'entity_type': {'key': 'entityType', 'type': 'str'},
        'direction': {'key': 'direction', 'type': 'str'},
        'entity_container_id': {'key': 'entityContainerId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword relation_type:
        :paramtype relation_type: str
        :keyword target_entity_id:
        :paramtype target_entity_id: str
        :keyword asset_id:
        :paramtype asset_id: str
        :keyword direction:
        :paramtype direction: str
        """
        super(Relationship, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.relation_type = kwargs.get('relation_type', None)
        self.target_entity_id = kwargs.get('target_entity_id', None)
        self.asset_id = kwargs.get('asset_id', None)
        self.entity_type = None
        self.direction = kwargs.get('direction', None)
        self.entity_container_id = None


class ServiceResponseBase(msrest.serialization.Model):
    """ServiceResponseBase.

    :ivar id:
    :vartype id: str
    :ivar name:
    :vartype name: str
    :ivar description:
    :vartype description: str
    :ivar tags: A set of tags.
    :vartype tags: list[str]
    :ivar kv_tags: Dictionary of :code:`<string>`.
    :vartype kv_tags: dict[str, str]
    :ivar properties: Dictionary of :code:`<string>`.
    :vartype properties: dict[str, str]
    :ivar operation_id:
    :vartype operation_id: str
    :ivar state: Possible values include: "Transitioning", "Healthy", "Unhealthy", "Failed",
     "Unschedulable".
    :vartype state: str or ~azure.mgmt.machinelearningservices.models.WebServiceState
    :ivar created_time:
    :vartype created_time: ~datetime.datetime
    :ivar updated_time:
    :vartype updated_time: ~datetime.datetime
    :ivar error:
    :vartype error: ~azure.mgmt.machinelearningservices.models.ErrorResponse
    :ivar compute_type: Possible values include: "ACS", "FPGA", "ACI", "AKS", "AMLCOMPUTE", "IOT",
     "MIR", "AKSENDPOINT", "MIRSINGLEMODEL", "MIRAMLCOMPUTE", "MIRGA", "AMLARC", "BATCHAMLCOMPUTE",
     "UNKNOWN".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeEnvironmentType
    :ivar deployment_type: Possible values include: "GRPCRealtimeEndpoint", "HttpRealtimeEndpoint",
     "Batch".
    :vartype deployment_type: str or ~azure.mgmt.machinelearningservices.models.DeploymentType
    :ivar created_by:
    :vartype created_by: ~azure.mgmt.machinelearningservices.models.User
    :ivar endpoint_name:
    :vartype endpoint_name: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '[str]'},
        'kv_tags': {'key': 'kvTags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'operation_id': {'key': 'operationId', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'updated_time': {'key': 'updatedTime', 'type': 'iso-8601'},
        'error': {'key': 'error', 'type': 'ErrorResponse'},
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'deployment_type': {'key': 'deploymentType', 'type': 'str'},
        'created_by': {'key': 'createdBy', 'type': 'User'},
        'endpoint_name': {'key': 'endpointName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword id:
        :paramtype id: str
        :keyword name:
        :paramtype name: str
        :keyword description:
        :paramtype description: str
        :keyword tags: A set of tags.
        :paramtype tags: list[str]
        :keyword kv_tags: Dictionary of :code:`<string>`.
        :paramtype kv_tags: dict[str, str]
        :keyword properties: Dictionary of :code:`<string>`.
        :paramtype properties: dict[str, str]
        :keyword operation_id:
        :paramtype operation_id: str
        :keyword state: Possible values include: "Transitioning", "Healthy", "Unhealthy", "Failed",
         "Unschedulable".
        :paramtype state: str or ~azure.mgmt.machinelearningservices.models.WebServiceState
        :keyword created_time:
        :paramtype created_time: ~datetime.datetime
        :keyword updated_time:
        :paramtype updated_time: ~datetime.datetime
        :keyword error:
        :paramtype error: ~azure.mgmt.machinelearningservices.models.ErrorResponse
        :keyword compute_type: Possible values include: "ACS", "FPGA", "ACI", "AKS", "AMLCOMPUTE",
         "IOT", "MIR", "AKSENDPOINT", "MIRSINGLEMODEL", "MIRAMLCOMPUTE", "MIRGA", "AMLARC",
         "BATCHAMLCOMPUTE", "UNKNOWN".
        :paramtype compute_type: str or
         ~azure.mgmt.machinelearningservices.models.ComputeEnvironmentType
        :keyword deployment_type: Possible values include: "GRPCRealtimeEndpoint",
         "HttpRealtimeEndpoint", "Batch".
        :paramtype deployment_type: str or ~azure.mgmt.machinelearningservices.models.DeploymentType
        :keyword created_by:
        :paramtype created_by: ~azure.mgmt.machinelearningservices.models.User
        :keyword endpoint_name:
        :paramtype endpoint_name: str
        """
        super(ServiceResponseBase, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.tags = kwargs.get('tags', None)
        self.kv_tags = kwargs.get('kv_tags', None)
        self.properties = kwargs.get('properties', None)
        self.operation_id = kwargs.get('operation_id', None)
        self.state = kwargs.get('state', None)
        self.created_time = kwargs.get('created_time', None)
        self.updated_time = kwargs.get('updated_time', None)
        self.error = kwargs.get('error', None)
        self.compute_type = kwargs.get('compute_type', None)
        self.deployment_type = kwargs.get('deployment_type', None)
        self.created_by = kwargs.get('created_by', None)
        self.endpoint_name = kwargs.get('endpoint_name', None)


class User(msrest.serialization.Model):
    """User.

    :ivar user_object_id:
    :vartype user_object_id: str
    :ivar user_pu_id:
    :vartype user_pu_id: str
    :ivar user_idp:
    :vartype user_idp: str
    :ivar user_alt_sec_id:
    :vartype user_alt_sec_id: str
    :ivar user_iss:
    :vartype user_iss: str
    :ivar user_tenant_id:
    :vartype user_tenant_id: str
    :ivar user_name:
    :vartype user_name: str
    :ivar upn:
    :vartype upn: str
    """

    _attribute_map = {
        'user_object_id': {'key': 'userObjectId', 'type': 'str'},
        'user_pu_id': {'key': 'userPuId', 'type': 'str'},
        'user_idp': {'key': 'userIdp', 'type': 'str'},
        'user_alt_sec_id': {'key': 'userAltSecId', 'type': 'str'},
        'user_iss': {'key': 'userIss', 'type': 'str'},
        'user_tenant_id': {'key': 'userTenantId', 'type': 'str'},
        'user_name': {'key': 'userName', 'type': 'str'},
        'upn': {'key': 'upn', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword user_object_id:
        :paramtype user_object_id: str
        :keyword user_pu_id:
        :paramtype user_pu_id: str
        :keyword user_idp:
        :paramtype user_idp: str
        :keyword user_alt_sec_id:
        :paramtype user_alt_sec_id: str
        :keyword user_iss:
        :paramtype user_iss: str
        :keyword user_tenant_id:
        :paramtype user_tenant_id: str
        :keyword user_name:
        :paramtype user_name: str
        :keyword upn:
        :paramtype upn: str
        """
        super(User, self).__init__(**kwargs)
        self.user_object_id = kwargs.get('user_object_id', None)
        self.user_pu_id = kwargs.get('user_pu_id', None)
        self.user_idp = kwargs.get('user_idp', None)
        self.user_alt_sec_id = kwargs.get('user_alt_sec_id', None)
        self.user_iss = kwargs.get('user_iss', None)
        self.user_tenant_id = kwargs.get('user_tenant_id', None)
        self.user_name = kwargs.get('user_name', None)
        self.upn = kwargs.get('upn', None)
